/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.trade;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.TradeCompletedEvent;
import com.cobblemon.mod.common.api.interaction.RequestManager;
import com.cobblemon.mod.common.api.interaction.ServerPlayerActionRequest;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.net.messages.client.trade.TradeOfferExpiredPacket;
import com.cobblemon.mod.common.net.messages.client.trade.TradeOfferNotificationPacket;
import com.cobblemon.mod.common.net.messages.client.trade.TradeStartedPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.evolution.variants.TradeEvolution;
import com.cobblemon.mod.common.trade.ActiveTrade;
import com.cobblemon.mod.common.trade.PlayerTradeParticipant;
import com.cobblemon.mod.common.trade.TradeManager;
import com.cobblemon.mod.common.trade.TradeParticipant;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ-\u0010%\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020!\u00a2\u0006\u0004\b%\u0010&R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lcom/cobblemon/mod/common/trade/TradeManager;", "Lcom/cobblemon/mod/common/api/interaction/RequestManager;", "Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;", "<init>", "()V", "Lcom/cobblemon/mod/common/trade/ActiveTrade;", "trade", "", "removeActiveTrade", "(Lcom/cobblemon/mod/common/trade/ActiveTrade;)Z", "Ljava/util/UUID;", "playerId", "getActiveTrade", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/trade/ActiveTrade;", "request", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "expirationPacket", "(Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;)Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "notificationPacket", "", "onAccept", "(Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;)V", "canAccept", "(Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;)Z", "Lnet/minecraft/class_3222;", "player", "target", "isValidInteraction", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;)Z", "onLogoff", "(Lnet/minecraft/class_3222;)V", "Lcom/cobblemon/mod/common/trade/TradeParticipant;", "player1", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon1", "player2", "pokemon2", "performTrade", "(Lcom/cobblemon/mod/common/trade/TradeParticipant;Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/trade/TradeParticipant;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "activeTrades", "Ljava/util/List;", "TradeRequest", "common"})
@SourceDebugExtension(value={"SMAP\nTradeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeManager.kt\ncom/cobblemon/mod/common/trade/TradeManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n*L\n1#1,123:1\n1#2:124\n808#3,11:125\n295#3,2:136\n808#3,11:138\n295#3,2:149\n14#4,5:151\n19#4:159\n13346#5:156\n13347#5:158\n14#6:157\n*S KotlinDebug\n*F\n+ 1 TradeManager.kt\ncom/cobblemon/mod/common/trade/TradeManager\n*L\n114#1:125,11\n114#1:136,2\n118#1:138,11\n118#1:149,2\n121#1:151,5\n121#1:159\n121#1:156\n121#1:158\n121#1:157\n*E\n"})
public final class TradeManager
extends RequestManager<TradeRequest> {
    @NotNull
    public static final TradeManager INSTANCE = new TradeManager();
    @NotNull
    private static final List<ActiveTrade> activeTrades;

    private TradeManager() {
    }

    public final boolean removeActiveTrade(@NotNull ActiveTrade trade) {
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        return activeTrades.remove(trade);
    }

    @Nullable
    public final ActiveTrade getActiveTrade(@NotNull UUID playerId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
            Iterable iterable = activeTrades;
            for (Object t : iterable) {
                ActiveTrade it = (ActiveTrade)t;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getPlayer1().getUuid(), (Object)playerId) || Intrinsics.areEqual((Object)it.getPlayer2().getUuid(), (Object)playerId))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    protected NetworkPacket<?> expirationPacket(@NotNull TradeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new TradeOfferExpiredPacket(request);
    }

    @Override
    @NotNull
    protected NetworkPacket<?> notificationPacket(@NotNull TradeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new TradeOfferNotificationPacket(request);
    }

    @Override
    protected void onAccept(@NotNull TradeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ActiveTrade trade = new ActiveTrade(new PlayerTradeParticipant(request.getReceiver()), new PlayerTradeParticipant(request.getSender()));
        activeTrades.add(trade);
        UUID uUID = request.getSender().method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        class_5250 class_52502 = request.getReceiver().method_5477().method_27662();
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"plainCopy(...)");
        request.sendToSender(new TradeStartedPacket(uUID, class_52502, trade.getPlayer1().getParty().mapNullPreserving(onAccept.1.INSTANCE)));
        UUID uUID2 = request.getReceiver().method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        class_5250 class_52503 = request.getSender().method_5477().method_27662();
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"plainCopy(...)");
        request.sendToReceiver(new TradeStartedPacket(uUID2, class_52503, trade.getPlayer2().getParty().mapNullPreserving(onAccept.2.INSTANCE)));
    }

    @Override
    protected boolean canAccept(@NotNull TradeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (CollectionsKt.none((Iterable)PlayerExtensionsKt.party(request.getSender()))) {
            request.notifySender(true, "error.insufficient_pokemon.self", new Object[0]);
            Object[] objectArray = new Object[1];
            class_5250 class_52502 = request.getSender().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52502);
            request.notifyReceiver(true, "error.insufficient_pokemon.other", objectArray);
        } else if (CollectionsKt.none((Iterable)PlayerExtensionsKt.party(request.getReceiver()))) {
            Object[] objectArray = new Object[1];
            class_5250 class_52503 = request.getSender().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52503);
            request.notifySender(true, "error.insufficient_pokemon.other", objectArray);
            request.notifyReceiver(true, "error.insufficient_pokemon.self", new Object[0]);
        } else {
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidInteraction(@NotNull class_3222 player, @NotNull class_3222 target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return PlayerExtensionsKt.canInteractWith(player, (class_1309)target, Cobblemon.INSTANCE.getConfig().getTradeMaxDistance());
    }

    @Override
    protected void onLogoff(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onLogoff(player);
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        ActiveTrade trade = this.getActiveTrade(uUID);
        if (trade != null) {
            UUID uUID2 = player.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            TradeParticipant tradeParticipant = trade.getTradeParticipant(uUID2);
            TradeParticipant oppositeParticipant = trade.getOppositePlayer(tradeParticipant);
            oppositeParticipant.cancelTrade(trade);
            this.removeActiveTrade(trade);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void performTrade(@NotNull TradeParticipant player1, @NotNull Pokemon pokemon1, @NotNull TradeParticipant player2, @NotNull Pokemon pokemon2) {
        void $this$iv;
        Object element$iv;
        EventObservable<TradeCompletedEvent> $this$firstOrNull$iv;
        Object element$iv$iv;
        Object $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player1, (String)"player1");
        Intrinsics.checkNotNullParameter((Object)pokemon1, (String)"pokemon1");
        Intrinsics.checkNotNullParameter((Object)player2, (String)"player2");
        Intrinsics.checkNotNullParameter((Object)pokemon2, (String)"pokemon2");
        PartyStore party1 = player1.getParty();
        PartyStore party2 = player2.getParty();
        party1.remove(pokemon1);
        party2.remove(pokemon2);
        Pokemon.setFriendship$default(pokemon1, pokemon1.getForm().getBaseFriendship(), false, 2, null);
        Pokemon.setFriendship$default(pokemon2, pokemon2.getForm().getBaseFriendship(), false, 2, null);
        party2.add(pokemon1);
        party1.add(pokemon2);
        Iterable $this$filterIsInstance$iv = pokemon1.getLockedEvolutions();
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof TradeEvolution)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$firstOrNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$firstOrNull$iv.iterator();
        while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
            element$iv = $this$filterIsInstanceTo$iv$iv.next();
            TradeEvolution it = (TradeEvolution)element$iv;
            boolean bl2 = false;
            if (!it.attemptEvolution(pokemon1, (Object)pokemon2)) continue;
            break;
        }
        $this$filterIsInstance$iv = pokemon2.getLockedEvolutions();
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        Iterator bl2 = $this$filterIsInstanceTo$iv$iv.iterator();
        while (bl2.hasNext()) {
            element$iv$iv = bl2.next();
            if (!(element$iv$iv instanceof TradeEvolution)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$firstOrNull = false;
        object = $this$firstOrNull$iv.iterator();
        while (object.hasNext()) {
            element$iv = object.next();
            TradeEvolution it = (TradeEvolution)element$iv;
            boolean bl3 = false;
            if (!it.attemptEvolution(pokemon2, (Object)pokemon1)) continue;
            break;
        }
        $this$firstOrNull$iv = CobblemonEvents.TRADE_COMPLETED;
        TradeCompletedEvent[] $i$f$firstOrNull2 = new TradeCompletedEvent[]{new TradeCompletedEvent(player1, pokemon2, player2, pokemon1)};
        TradeCompletedEvent[] events$iv = $i$f$firstOrNull2;
        boolean $i$f$post = false;
        $this$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
        TradeCompletedEvent[] $this$forEach$iv$iv = events$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            TradeCompletedEvent element$iv$iv2;
            TradeCompletedEvent tradeCompletedEvent = element$iv$iv2 = $this$forEach$iv$iv[i];
            boolean bl4 = false;
            TradeCompletedEvent it = tradeCompletedEvent;
        }
    }

    static {
        RequestManager.Companion.register(INSTANCE);
        activeTrades = new ArrayList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\nR\u001a\u0010\u0004\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0019\u001a\u0004\b\u001b\u0010\nR\u001a\u0010\u0006\u001a\u00020\u00058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001d\u0010\rR\u001a\u0010\u001e\u001a\u00020\u00168\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010\u0018R\u001a\u0010\"\u001a\u00020!8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;", "Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;", "Lnet/minecraft/class_3222;", "sender", "receiver", "", "expiryTime", "<init>", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;I)V", "component1", "()Lnet/minecraft/class_3222;", "component2", "component3", "()I", "copy", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;I)Lcom/cobblemon/mod/common/trade/TradeManager$TradeRequest;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_3222;", "getSender", "getReceiver", "I", "getExpiryTime", "key", "Ljava/lang/String;", "getKey", "Ljava/util/UUID;", "requestID", "Ljava/util/UUID;", "getRequestID", "()Ljava/util/UUID;", "common"})
    public static final class TradeRequest
    implements ServerPlayerActionRequest {
        @NotNull
        private final class_3222 sender;
        @NotNull
        private final class_3222 receiver;
        private final int expiryTime;
        @NotNull
        private final String key;
        @NotNull
        private final UUID requestID;

        public TradeRequest(@NotNull class_3222 sender, @NotNull class_3222 receiver, int expiryTime) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            this.sender = sender;
            this.receiver = receiver;
            this.expiryTime = expiryTime;
            this.key = "trade";
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            this.requestID = uUID;
        }

        public /* synthetic */ TradeRequest(class_3222 class_32222, class_3222 class_32223, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = 20;
            }
            this(class_32222, class_32223, n);
        }

        @Override
        @NotNull
        public class_3222 getSender() {
            return this.sender;
        }

        @Override
        @NotNull
        public class_3222 getReceiver() {
            return this.receiver;
        }

        @Override
        public int getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public UUID getRequestID() {
            return this.requestID;
        }

        @NotNull
        public final class_3222 component1() {
            return this.sender;
        }

        @NotNull
        public final class_3222 component2() {
            return this.receiver;
        }

        public final int component3() {
            return this.expiryTime;
        }

        @NotNull
        public final TradeRequest copy(@NotNull class_3222 sender, @NotNull class_3222 receiver, int expiryTime) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            return new TradeRequest(sender, receiver, expiryTime);
        }

        public static /* synthetic */ TradeRequest copy$default(TradeRequest tradeRequest, class_3222 class_32222, class_3222 class_32223, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                class_32222 = tradeRequest.sender;
            }
            if ((n2 & 2) != 0) {
                class_32223 = tradeRequest.receiver;
            }
            if ((n2 & 4) != 0) {
                n = tradeRequest.expiryTime;
            }
            return tradeRequest.copy(class_32222, class_32223, n);
        }

        @NotNull
        public String toString() {
            return "TradeRequest(sender=" + this.sender + ", receiver=" + this.receiver + ", expiryTime=" + this.expiryTime + ")";
        }

        public int hashCode() {
            int result = this.sender.hashCode();
            result = result * 31 + this.receiver.hashCode();
            result = result * 31 + Integer.hashCode(this.expiryTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TradeRequest)) {
                return false;
            }
            TradeRequest tradeRequest = (TradeRequest)other;
            if (!Intrinsics.areEqual((Object)this.sender, (Object)tradeRequest.sender)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.receiver, (Object)tradeRequest.receiver)) {
                return false;
            }
            return this.expiryTime == tradeRequest.expiryTime;
        }

        @Override
        @NotNull
        public UUID getReceiverID() {
            return ServerPlayerActionRequest.DefaultImpls.getReceiverID(this);
        }

        @Override
        @NotNull
        public UUID getSenderID() {
            return ServerPlayerActionRequest.DefaultImpls.getSenderID(this);
        }

        @Override
        public void sendToSender(@NotNull NetworkPacket<?> packet) {
            ServerPlayerActionRequest.DefaultImpls.sendToSender(this, packet);
        }

        @Override
        public void sendToReceiver(@NotNull NetworkPacket<?> packet) {
            ServerPlayerActionRequest.DefaultImpls.sendToReceiver(this, packet);
        }

        @Override
        public void notifySender(boolean error, @NotNull String langKey, Object ... params) {
            ServerPlayerActionRequest.DefaultImpls.notifySender(this, error, langKey, params);
        }

        @Override
        public void notifyReceiver(boolean error, @NotNull String langKey, Object ... params) {
            ServerPlayerActionRequest.DefaultImpls.notifyReceiver(this, error, langKey, params);
        }

        @Override
        public void notify(@NotNull class_3222 player, boolean error, @NotNull String langKey, Object ... params) {
            ServerPlayerActionRequest.DefaultImpls.notify(this, player, error, langKey, params);
        }
    }
}

