/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.graalvm.polyglot.proxy;

import com.cobblemon.mod.relocations.graalvm.polyglot.Value;
import com.cobblemon.mod.relocations.graalvm.polyglot.proxy.ProxyArray;
import com.cobblemon.mod.relocations.graalvm.polyglot.proxy.ProxyHashMap;
import com.cobblemon.mod.relocations.graalvm.polyglot.proxy.ProxyIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

final class ProxyHashMapImpl
implements ProxyHashMap {
    private final Map<Object, Object> values;

    ProxyHashMapImpl(Map<Object, Object> values) {
        this.values = values;
    }

    @Override
    public long getHashSize() {
        return this.values.size();
    }

    @Override
    public boolean hasHashEntry(Value key) {
        Object unboxedKey = ProxyHashMapImpl.unboxKey(key);
        return this.values.containsKey(unboxedKey);
    }

    @Override
    public Object getHashValue(Value key) {
        Object unboxedKey = ProxyHashMapImpl.unboxKey(key);
        return this.values.get(unboxedKey);
    }

    @Override
    public void putHashEntry(Value key, Value value) {
        Object unboxedKey = ProxyHashMapImpl.unboxKey(key);
        this.values.put(unboxedKey, value.isHostObject() ? value.asHostObject() : value);
    }

    @Override
    public boolean removeHashEntry(Value key) {
        Object unboxedKey = ProxyHashMapImpl.unboxKey(key);
        if (this.values.containsKey(unboxedKey)) {
            this.values.remove(unboxedKey);
            return true;
        }
        return false;
    }

    @Override
    public Object getHashEntriesIterator() {
        final Iterator<Map.Entry<Object, Object>> entryIterator = this.values.entrySet().iterator();
        return new ProxyIterator(){

            @Override
            public boolean hasNext() {
                return entryIterator.hasNext();
            }

            @Override
            public Object getNext() throws NoSuchElementException, UnsupportedOperationException {
                return new ProxyEntryImpl((Map.Entry)entryIterator.next());
            }
        };
    }

    private static Object unboxKey(Value key) {
        return key.as(Object.class);
    }

    private class ProxyEntryImpl
    implements ProxyArray {
        private Map.Entry<Object, Object> mapEntry;

        ProxyEntryImpl(Map.Entry<Object, Object> mapEntry) {
            this.mapEntry = mapEntry;
        }

        @Override
        public Object get(long index) {
            if (index == 0L) {
                return this.mapEntry.getKey();
            }
            if (index == 1L) {
                return this.mapEntry.getValue();
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        @Override
        public void set(long index, Value value) {
            if (index == 0L) {
                throw new UnsupportedOperationException();
            }
            if (index != 1L) {
                throw new ArrayIndexOutOfBoundsException();
            }
            ProxyHashMapImpl.this.values.put(this.mapEntry.getKey(), value.isHostObject() ? value.asHostObject() : value);
        }

        @Override
        public long getSize() {
            return 2L;
        }
    }
}

