/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Cached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.BranchProfile;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.js.lang.JavaScriptLanguage;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSConcatStringsNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Errors;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Strings;

public abstract class JSConcatStringsNode
extends JavaScriptBaseNode {
    protected final int stringLengthLimit;

    protected JSConcatStringsNode(int stringLengthLimit) {
        this.stringLengthLimit = stringLengthLimit;
    }

    public static JSConcatStringsNode create(int stringLengthLimit) {
        return JSConcatStringsNodeGen.create(stringLengthLimit);
    }

    public static JSConcatStringsNode create() {
        return JSConcatStringsNode.create(JavaScriptLanguage.getCurrentLanguage().getJSContext().getStringLengthLimit());
    }

    public abstract TruffleString executeTString(TruffleString var1, TruffleString var2);

    @Specialization
    protected final TruffleString doConcat(TruffleString left, TruffleString right, @Cached BranchProfile errorBranch, @Cached TruffleString.ConcatNode concatNode) {
        this.validateStringLength(Strings.length(left) + Strings.length(right), errorBranch);
        return Strings.concat(concatNode, left, right);
    }

    private void validateStringLength(int resultLength, BranchProfile errorBranch) {
        if (CompilerDirectives.injectBranchProbability(1.0E-4, resultLength < 0 || resultLength > this.stringLengthLimit)) {
            errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength(this);
        }
    }
}

