/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.TruffleLanguage;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Cached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Fallback;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.ImportStatic;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.ArityException;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.InteropLibrary;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.UnknownIdentifierException;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.UnsupportedMessageException;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.UnsupportedTypeException;
import com.cobblemon.mod.relocations.oracle.truffle.api.library.CachedLibrary;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.ConditionProfile;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.js.lang.JavaScriptLanguage;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.IsPrimitiveNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToPrimitiveNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.OrdinaryToPrimitiveNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.BigInt;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Errors;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSArguments;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSConfig;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSRealm;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSRuntime;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.SafeInteger;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Strings;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Symbol;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.Null;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.Undefined;

@ImportStatic(value={JSConfig.class})
public abstract class JSToPrimitiveNode
extends JavaScriptBaseNode {
    @Node.Child
    private OrdinaryToPrimitiveNode ordinaryToPrimitiveNode;
    protected final Hint hint;

    protected JSToPrimitiveNode(Hint hint) {
        this.hint = hint;
    }

    public abstract Object execute(Object var1);

    public static JSToPrimitiveNode createHintDefault() {
        return JSToPrimitiveNode.create(Hint.Default);
    }

    public static JSToPrimitiveNode createHintString() {
        return JSToPrimitiveNode.create(Hint.String);
    }

    public static JSToPrimitiveNode createHintNumber() {
        return JSToPrimitiveNode.create(Hint.Number);
    }

    public static JSToPrimitiveNode create(Hint hint) {
        return JSToPrimitiveNodeGen.create(hint);
    }

    @Specialization
    protected int doInt(int value) {
        return value;
    }

    @Specialization
    protected SafeInteger doSafeInteger(SafeInteger value) {
        return value;
    }

    @Specialization
    protected long doLong(long value) {
        return value;
    }

    @Specialization
    protected double doDouble(double value) {
        return value;
    }

    @Specialization
    protected boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization
    protected Object doString(TruffleString value) {
        return value;
    }

    @Specialization
    protected Symbol doSymbol(Symbol value) {
        return value;
    }

    @Specialization
    protected BigInt doBigInt(BigInt value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected JSDynamicObject doNull(Object value) {
        return Null.instance;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected JSDynamicObject doUndefined(Object value) {
        return Undefined.instance;
    }

    @Specialization
    protected Object doJSObject(JSObject object, @Cached(value="createGetToPrimitive()") PropertyGetNode getToPrimitive, @Cached IsPrimitiveNode isPrimitive, @Cached ConditionProfile exoticToPrimProfile, @Cached(value="createCall()") JSFunctionCallNode callExoticToPrim) {
        Object exoticToPrim = getToPrimitive.getValue(object);
        if (exoticToPrimProfile.profile(!JSRuntime.isNullOrUndefined(exoticToPrim))) {
            Object result = callExoticToPrim.executeCall(JSArguments.createOneArg(object, exoticToPrim, this.hint.getHintName()));
            if (isPrimitive.executeBoolean(result)) {
                return result;
            }
            throw Errors.createTypeError("[Symbol.toPrimitive] method returned a non-primitive object", (Node)this);
        }
        return this.ordinaryToPrimitive(object);
    }

    protected final boolean isHintString() {
        return this.hint == Hint.String;
    }

    @Specialization(guards={"isForeignObject(object)"}, limit="InteropLibraryLimit")
    protected Object doForeignObject(Object object, @CachedLibrary(value="object") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary resultInterop) {
        Object maybeResult;
        if (interop.isNull(object)) {
            return Null.instance;
        }
        try {
            if (interop.isBoolean(object)) {
                return interop.asBoolean(object);
            }
            if (interop.isString(object)) {
                return interop.asTruffleString(object);
            }
            if (interop.isNumber(object)) {
                if (interop.fitsInInt(object)) {
                    return interop.asInt(object);
                }
                if (interop.fitsInLong(object)) {
                    return interop.asLong(object);
                }
                if (interop.fitsInDouble(object)) {
                    return interop.asDouble(object);
                }
            }
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(object, e, this);
        }
        JSRealm realm = this.getRealm();
        TruffleLanguage.Env env = realm.getEnv();
        if (env.isHostObject(object) && (maybeResult = JSToPrimitiveNode.tryHostObjectToPrimitive(object, this.hint, interop)) != null) {
            return maybeResult;
        }
        Object result = this.ordinaryToPrimitive(object);
        assert (IsPrimitiveNode.getUncached().executeBoolean(result)) : result;
        return JSInteropUtil.toPrimitiveOrDefault(result, result, resultInterop, this);
    }

    public static Object tryHostObjectToPrimitive(Object object, Hint hint, InteropLibrary interop) {
        if (hint != Hint.String && JavaScriptLanguage.get(interop).getJSContext().isOptionNashornCompatibilityMode() && interop.isMemberInvocable(object, "doubleValue")) {
            try {
                return interop.invokeMember(object, "doubleValue", new Object[0]);
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeErrorInteropException(object, e, "doubleValue()", interop);
            }
        }
        if (interop.isMetaObject(object)) {
            return JSToPrimitiveNode.javaClassToString(object, interop);
        }
        if (interop.isException(object)) {
            return JSToPrimitiveNode.javaExceptionToString(object, interop);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString javaClassToString(Object object, InteropLibrary interop) {
        try {
            String qualifiedName = InteropLibrary.getUncached().asString(interop.getMetaQualifiedName(object));
            if (JavaScriptLanguage.get(interop).getJSContext().isOptionNashornCompatibilityMode() && qualifiedName.endsWith("[]")) {
                Object hostObject = JSRealm.get(interop).getEnv().asHostObject(object);
                qualifiedName = ((Class)hostObject).getName();
            }
            return Strings.fromJavaString("class " + qualifiedName);
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(object, e, "getTypeName", interop);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString javaExceptionToString(Object object, InteropLibrary interop) {
        try {
            return InteropLibrary.getUncached().asTruffleString(interop.toDisplayString(object, true));
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(object, e, "toString", interop);
        }
    }

    @Fallback
    protected TruffleString doFallback(Object value) {
        assert (value != null);
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(this);
    }

    private Object ordinaryToPrimitive(Object object) {
        if (this.ordinaryToPrimitiveNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.ordinaryToPrimitiveNode = this.insert(this.createOrdinaryToPrimitive());
        }
        return this.ordinaryToPrimitiveNode.execute(object);
    }

    protected PropertyGetNode createGetToPrimitive() {
        return PropertyGetNode.createGetMethod(Symbol.SYMBOL_TO_PRIMITIVE, this.getLanguage().getJSContext());
    }

    protected OrdinaryToPrimitiveNode createOrdinaryToPrimitive() {
        return OrdinaryToPrimitiveNode.create(this.isHintString() ? Hint.String : Hint.Number);
    }

    public static enum Hint {
        Default(Strings.HINT_DEFAULT),
        Number(Strings.HINT_NUMBER),
        String(Strings.HINT_STRING);

        private final TruffleString hintName;

        private Hint(TruffleString hintName) {
            this.hintName = hintName;
        }

        public TruffleString getHintName() {
            return this.hintName;
        }
    }
}

