/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control;

import com.cobblemon.mod.relocations.oracle.truffle.api.frame.VirtualFrame;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.YieldException;
import java.util.Collections;

public abstract class YieldResultNode
extends JavaScriptBaseNode {
    public abstract YieldException generatorYield(VirtualFrame var1, Object var2);

    public abstract YieldResultNode cloneUninitialized();

    public static final class FrameYieldResultNode
    extends YieldResultNode {
        @Node.Child
        private JSWriteFrameSlotNode writeYieldValueNode;

        public FrameYieldResultNode(JSWriteFrameSlotNode writeYieldValueNode) {
            this.writeYieldValueNode = writeYieldValueNode;
        }

        @Override
        public YieldException generatorYield(VirtualFrame frame, Object value) {
            this.writeYieldValueNode.executeWrite(frame, value);
            throw YieldException.YIELD_NULL;
        }

        @Override
        public YieldResultNode cloneUninitialized() {
            return new FrameYieldResultNode(JavaScriptNode.cloneUninitialized(this.writeYieldValueNode, Collections.emptySet()));
        }
    }

    public static final class ExceptionYieldResultNode
    extends YieldResultNode {
        @Override
        public YieldException generatorYield(VirtualFrame frame, Object value) {
            throw new YieldException(value);
        }

        @Override
        public YieldResultNode cloneUninitialized() {
            return new ExceptionYieldResultNode();
        }
    }
}

