/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.temporal;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Cached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.BranchProfile;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.ConditionProfile;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.IsObjectNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.temporal.ToTemporalCalendarNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSContext;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendar;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.temporal.TemporalCalendar;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.util.TemporalConstants;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.util.TemporalErrors;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalCalendarNode
extends JavaScriptBaseNode {
    private final ConditionProfile isObjectProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isCalendarProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile hasCalendarProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile hasCalendar2Profile = ConditionProfile.createBinaryProfile();
    private final BranchProfile parseBranch = BranchProfile.create();
    private final JSContext context;
    @Node.Child
    private PropertyGetNode getCalendarPropertyNode;

    protected ToTemporalCalendarNode(JSContext context) {
        this.context = context;
    }

    public static ToTemporalCalendarNode create(JSContext context) {
        return ToTemporalCalendarNodeGen.create(context);
    }

    public abstract JSDynamicObject executeDynamicObject(Object var1);

    @Specialization
    public JSDynamicObject toTemporalCalendar(Object itemParam, @Cached BranchProfile errorBranch, @Cached(value="create()") IsObjectNode isObjectNode, @Cached(value="create()") JSToStringNode toStringNode) {
        TruffleString identifier2;
        Object item = itemParam;
        if (this.isObjectProfile.profile(isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = TemporalUtil.toJSDynamicObject(item, errorBranch);
            if (this.isCalendarProfile.profile(item instanceof TemporalCalendar)) {
                return ((TemporalCalendar)item).getCalendar();
            }
            if (this.hasCalendarProfile.profile(!JSObject.hasProperty(itemObj, TemporalConstants.CALENDAR))) {
                return itemObj;
            }
            item = this.getCalendarProperty(itemObj);
            if (this.hasCalendar2Profile.profile(isObjectNode.executeBoolean(item) && !JSObject.hasProperty((JSDynamicObject)item, TemporalConstants.CALENDAR))) {
                return (JSDynamicObject)item;
            }
        }
        if (!TemporalUtil.isBuiltinCalendar(identifier2 = toStringNode.executeString(item))) {
            this.parseBranch.enter();
            identifier2 = TemporalUtil.parseTemporalCalendarString(identifier2);
            if (!TemporalUtil.isBuiltinCalendar(identifier2)) {
                throw TemporalErrors.createRangeErrorCalendarUnknown();
            }
        }
        return JSTemporalCalendar.create(this.context, this.getRealm(), identifier2, errorBranch);
    }

    private Object getCalendarProperty(JSDynamicObject obj) {
        if (this.getCalendarPropertyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getCalendarPropertyNode = this.insert(PropertyGetNode.create(TemporalConstants.CALENDAR, false, this.context));
        }
        return this.getCalendarPropertyNode.getValue(obj);
    }
}

