/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.object.Shape;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.js.builtins.WeakMapPrototypeBuiltins;
import com.cobblemon.mod.relocations.oracle.truffle.js.lang.JavaScriptLanguage;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSContext;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSRealm;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Strings;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSWeakMapObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.util.WeakMap;
import java.util.Map;

public final class JSWeakMap
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final JSWeakMap INSTANCE = new JSWeakMap();
    public static final TruffleString CLASS_NAME = Strings.constant("WeakMap");
    public static final TruffleString PROTOTYPE_NAME = Strings.concat(CLASS_NAME, Strings.DOT_PROTOTYPE);

    private JSWeakMap() {
    }

    public static JSWeakMapObject create(JSContext context, JSRealm realm) {
        WeakMap weakMap = new WeakMap();
        JSObjectFactory factory = context.getWeakMapFactory();
        JSWeakMapObject obj = factory.initProto(new JSWeakMapObject(factory.getShape(realm), weakMap), realm);
        return context.trackAllocation(obj);
    }

    public static Map<JSObject, Object> getInternalWeakMap(JSDynamicObject obj) {
        assert (JSWeakMap.isJSWeakMap(obj));
        return ((JSWeakMapObject)obj).getWeakHashMap();
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSContext ctx = realm.getContext();
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, WeakMapPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return this.getClassName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(JSDynamicObject obj, boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return Strings.addBrackets(this.getClassName());
        }
        return this.getClassName();
    }

    public static boolean isJSWeakMap(Object obj) {
        return obj instanceof JSWeakMapObject;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWeakMapPrototype();
    }
}

