/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record PlayerGUIOperationMessage(Operation op, List<UUID> targets) implements class_8710
{
    public static final class_8710.class_9154<PlayerGUIOperationMessage> TYPE = new class_8710.class_9154(FTBTeamsAPI.rl("player_gui_operation"));
    public static final class_9139<class_2540, PlayerGUIOperationMessage> STREAM_CODEC = class_9139.method_56435((class_9139)NetworkHelper.enumStreamCodec(Operation.class), PlayerGUIOperationMessage::op, (class_9139)class_4844.field_48453.method_56433(class_9135.method_56363()), PlayerGUIOperationMessage::targets, PlayerGUIOperationMessage::new);

    public static PlayerGUIOperationMessage forUUID(Operation op, UUID target) {
        return new PlayerGUIOperationMessage(op, List.of(target));
    }

    public static PlayerGUIOperationMessage forGameProfiles(Operation op, Collection<GameProfile> targets) {
        return new PlayerGUIOperationMessage(op, targets.stream().map(GameProfile::getId).toList());
    }

    public static void handle(PlayerGUIOperationMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            class_1657 patt0$temp = context.getPlayer();
            if (!(patt0$temp instanceof class_3222)) {
                return;
            }
            class_3222 serverPlayer = (class_3222)patt0$temp;
            UUID senderId = context.getPlayer().method_5667();
            FTBTeamsAPI.api().getManager().getTeamForPlayerID(senderId).ifPresent(team -> {
                if (team instanceof PartyTeam) {
                    PartyTeam partyTeam = (PartyTeam)team;
                    TeamRank senderRank = partyTeam.getRankForPlayer(serverPlayer.method_5667());
                    message.targets.forEach(target -> PlayerGUIOperationMessage.processTarget(serverPlayer, senderRank, partyTeam, message.op, target));
                }
            });
        });
    }

    private static void processTarget(class_3222 sourcePlayer, TeamRank senderRank, PartyTeam partyTeam, Operation op, UUID targetId) {
        if (op.requireSameTeam() && !FTBTeamsAPI.api().getManager().arePlayersInSameTeam(sourcePlayer.method_5667(), targetId)) {
            return;
        }
        TeamRank targetRank = partyTeam.getRankForPlayer(targetId);
        FTBTeams.LOGGER.debug("received teams operation msg {} from {} (rank {}), team {}, target {} (rank {})", (Object)op, (Object)sourcePlayer.method_5667(), (Object)senderRank, (Object)partyTeam.getName().getString(), (Object)targetId, (Object)targetRank);
        try {
            List<GameProfile> targetProfile = List.of(new GameProfile(targetId, ""));
            switch (op.ordinal()) {
                case 3: {
                    if (senderRank.getPower() <= targetRank.getPower()) break;
                    partyTeam.kick(sourcePlayer.method_5671(), targetProfile);
                    break;
                }
                case 0: {
                    if (!senderRank.isAtLeast(TeamRank.OWNER) || !targetRank.isAtLeast(TeamRank.MEMBER)) break;
                    partyTeam.promote(sourcePlayer, targetProfile);
                    break;
                }
                case 1: {
                    if (!senderRank.isAtLeast(TeamRank.OWNER) || !targetRank.isAtLeast(TeamRank.OFFICER)) break;
                    partyTeam.demote(sourcePlayer, targetProfile);
                    break;
                }
                case 4: {
                    if (!senderRank.isAtLeast(TeamRank.OWNER)) break;
                    class_3222 p = sourcePlayer.method_5682().method_3760().method_14602(targetId);
                    if (p != null) {
                        partyTeam.transferOwnership(sourcePlayer.method_5671(), p.method_7334());
                    }
                    break;
                }
                case 2: {
                    partyTeam.leave(sourcePlayer.method_5667());
                    break;
                }
                case 5: {
                    if (!senderRank.isAtLeast(TeamRank.OFFICER)) break;
                    class_3222 p = sourcePlayer.method_5682().method_3760().method_14602(targetId);
                    if (p != null) {
                        partyTeam.invite(sourcePlayer, List.of(p.method_7334()));
                    }
                    break;
                }
                case 6: {
                    if (!senderRank.isAtLeast(TeamRank.OFFICER) || !targetRank.isAtLeast(TeamRank.NONE)) break;
                    partyTeam.addAlly(sourcePlayer.method_5671(), targetProfile);
                    break;
                }
                case 7: {
                    if (!senderRank.isAtLeast(TeamRank.OFFICER) || !targetRank.isAtLeast(TeamRank.ALLY)) break;
                    partyTeam.removeAlly(sourcePlayer.method_5671(), targetProfile);
                }
            }
        }
        catch (CommandSyntaxException e) {
            sourcePlayer.method_7353((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061), false);
        }
    }

    public class_8710.class_9154<PlayerGUIOperationMessage> method_56479() {
        return TYPE;
    }

    public static enum Operation {
        PROMOTE(true),
        DEMOTE(true),
        LEAVE(true),
        KICK(true),
        TRANSFER_OWNER(true),
        INVITE(false),
        ADD_ALLY(false),
        REMOVE_ALLY(false);

        private final boolean requireSameTeam;

        private Operation(boolean requireSameTeam) {
            this.requireSameTeam = requireSameTeam;
        }

        boolean requireSameTeam() {
            return this.requireSameTeam;
        }

        public void sendMessage(KnownClientPlayer target) {
            NetworkManager.sendToServer((class_8710)PlayerGUIOperationMessage.forUUID(this, target.id()));
        }
    }
}

