/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.compat;

import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.compat.AccessoriesCompat;
import dev.lambdaurora.lambdynlights.compat.TrinketsCompat;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import org.jetbrains.annotations.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CompatLayer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights|CompatLayer");
    public static final List<CompatLayer> LAYERS = CompatLayer.initLayers();

    public @Range(from=0L, to=15L) int getLivingEntityLuminanceFromItems(class_1309 var1, boolean var2);

    private static List<CompatLayer> initLayers() {
        ArrayList<CompatLayer> layers = new ArrayList<CompatLayer>();
        try {
            if (FabricLoader.getInstance().isModLoaded("accessories")) {
                layers.add(new AccessoriesCompat());
            } else if (FabricLoader.getInstance().isModLoaded("trinkets")) {
                layers.add(new TrinketsCompat());
            }
        }
        catch (LinkageError e) {
            LambDynLights.error(LOGGER, "Could not load a compatibility layer: THIS IS VERY WRONG, PLEASE REPORT THIS ERROR TO LAMBDYNAMICLIGHTS' AUTHOR ASAP.", e);
        }
        return layers;
    }
}

