/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event.invoker;

import dev.yumi.commons.event.invoker.Descriptors;
import dev.yumi.commons.event.invoker.InvokerFactory;
import dev.yumi.commons.event.invoker.OpcodeUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public abstract class DynamicInvokerFactory<T>
extends InvokerFactory<T> {
    private static final AtomicInteger CLASS_COUNTER = new AtomicInteger(0);
    protected static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    protected final MethodType listenerMethodType;
    protected final MethodHandle constructor;

    protected DynamicInvokerFactory(@NotNull Class<? super T> type) {
        this(type, DynamicInvokerFactory.getFunctionalMethod(type));
    }

    protected DynamicInvokerFactory(@NotNull Class<? super T> type, @NotNull Method listenerMethod) {
        super(type);
        this.checkMethod(listenerMethod);
        try {
            this.listenerMethodType = MethodType.methodType(listenerMethod.getReturnType(), listenerMethod.getParameterTypes());
            String implementationInnerClassRawName = this.type.getSimpleName() + CLASS_COUNTER.getAndIncrement() + "Impl";
            String implName = "$" + implementationInnerClassRawName;
            if (this.getClass() != DynamicInvokerFactory.class) {
                implName = "$" + this.getClass().getSimpleName() + implName;
            }
            String implementationFullInnerClassRawName = DynamicInvokerFactory.class.getSimpleName() + implName;
            String implementationClassRawName = DynamicInvokerFactory.class.getName().replace('.', '/') + implName;
            this.constructor = this.buildClass(listenerMethod.getName(), this.type.getName().replace('.', '/'), implementationInnerClassRawName, implementationFullInnerClassRawName, implementationClassRawName);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Contract(pure=true)
    protected abstract void checkMethod(@NotNull Method var1);

    private MethodHandle buildClass(String listenerMethodName, String typeRawName, String implementationInnerClassRawName, String implementationFullInnerClassRawName, String implementationClassRawName) throws IllegalAccessException, NoSuchMethodException {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(61, 49, implementationClassRawName, null, "java/lang/Object", new String[]{typeRawName});
        cw.visitSource(implementationFullInnerClassRawName, null);
        WriterContext context = new WriterContext(cw, listenerMethodName, typeRawName, implementationInnerClassRawName, implementationFullInnerClassRawName, implementationClassRawName, this.getParamTable());
        context.addField("listeners", Descriptors.describe(this.type.arrayType()));
        StringBuilder descriptor = new StringBuilder("(");
        for (String field : context.fields.values()) {
            descriptor.append(field);
        }
        descriptor.append(")V");
        MethodVisitor mv = cw.visitMethod(1, "<init>", descriptor.toString(), null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        int offset = 1;
        for (Map.Entry<String, String> field : context.fields.entrySet()) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(OpcodeUtils.getLoadOpcodeFromType(field.getValue()), offset);
            mv.visitFieldInsn(181, implementationClassRawName, field.getKey(), field.getValue());
            offset += Descriptors.getTypeSize(field.getValue());
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        MethodVisitor mv2 = cw.visitMethod(1, listenerMethodName, this.listenerMethodType.toMethodDescriptorString(), null, null);
        this.writeImplementationMethod(mv2, context);
        mv2.visitMaxs(0, 0);
        mv2.visitEnd();
        byte[] bytes = cw.toByteArray();
        MethodHandles.Lookup lookup = LOOKUP.defineHiddenClass(bytes, true, new MethodHandles.Lookup.ClassOption[0]);
        return lookup.findConstructor(lookup.lookupClass(), MethodType.methodType(Void.TYPE, this.type.arrayType()));
    }

    protected abstract void writeImplementationMethod(MethodVisitor var1, WriterContext var2);

    protected void writeMethodStart(MethodVisitor mv, WriterContext context) {
        this.preparePreLoop(mv, context);
        this.writeLoopStart(mv, context);
        for (LocalEntry param : context.paramTable().params()) {
            mv.visitVarInsn(OpcodeUtils.getLoadOpcodeFromType(param.type()), param.index());
        }
        context.writeMethodInvoke(mv);
    }

    protected void preparePreLoop(MethodVisitor mv, WriterContext context) {
        mv.visitVarInsn(25, 0);
        context.writeGetField(mv, "listeners");
        mv.visitVarInsn(58, context.listenersVar);
        mv.visitVarInsn(25, context.listenersVar);
        mv.visitInsn(190);
        mv.visitVarInsn(54, context.listenersLengthVar);
        mv.visitInsn(3);
        mv.visitVarInsn(54, context.iVar);
    }

    protected void writeLoopStart(MethodVisitor mv, WriterContext context) {
        mv.visitLabel(context.forStartLabel);
        mv.visitVarInsn(21, context.iVar);
        mv.visitVarInsn(21, context.listenersLengthVar);
        mv.visitJumpInsn(162, context.forEndLabel);
        mv.visitLabel(new Label());
        mv.visitVarInsn(25, context.listenersVar);
        mv.visitVarInsn(21, context.iVar);
        mv.visitInsn(50);
    }

    protected void writeIncrement(MethodVisitor mv, WriterContext context) {
        mv.visitLabel(new Label());
        mv.visitIincInsn(context.iVar, 1);
        mv.visitJumpInsn(167, context.forStartLabel);
    }

    @Override
    public T apply(T[] listeners) {
        try {
            return (T)this.constructor.invoke(listeners);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected ParamTable getParamTable() {
        ArrayList<LocalEntry> params = new ArrayList<LocalEntry>();
        int localStart = 1;
        for (int i = 0; i < this.listenerMethodType.parameterCount(); ++i) {
            TypeDescriptor.OfField paramType = this.listenerMethodType.parameterType(i);
            params.add(new LocalEntry(localStart, (Class<?>)paramType));
            if (paramType == Long.TYPE || paramType == Double.TYPE) {
                localStart += 2;
                continue;
            }
            ++localStart;
        }
        return new ParamTable(localStart, params);
    }

    protected class WriterContext {
        private final ClassWriter cw;
        private final String listenerMethodName;
        private final String typeRawName;
        private final String implementationInnerClassRawName;
        private final String implementationFullInnerClassRawName;
        private final String implementationClassRawName;
        private final ParamTable paramTable;
        private final int listenersVar;
        private final int listenersLengthVar;
        private final int iVar;
        private final Label forStartLabel = new Label();
        private final Label forEndLabel = new Label();
        private final Map<String, String> fields = new HashMap<String, String>();

        WriterContext(ClassWriter cw, String listenerMethodName, String typeRawName, String implementationInnerClassRawName, String implementationFullInnerClassRawName, String implementationClassRawName, ParamTable paramTable) {
            this.cw = cw;
            this.listenerMethodName = listenerMethodName;
            this.typeRawName = typeRawName;
            this.implementationInnerClassRawName = implementationInnerClassRawName;
            this.implementationFullInnerClassRawName = implementationFullInnerClassRawName;
            this.implementationClassRawName = implementationClassRawName;
            this.paramTable = paramTable;
            this.listenersVar = paramTable.localStart;
            this.listenersLengthVar = this.listenersVar + 1;
            this.iVar = this.listenersLengthVar + 1;
        }

        public String listenerMethodName() {
            return this.listenerMethodName;
        }

        public String typeRawName() {
            return this.typeRawName;
        }

        public String implementationInnerClassRawName() {
            return this.implementationInnerClassRawName;
        }

        public String implementationFullInnerClassRawName() {
            return this.implementationFullInnerClassRawName;
        }

        public String implementationClassRawName() {
            return this.implementationClassRawName;
        }

        public ParamTable paramTable() {
            return this.paramTable;
        }

        public int listenersVar() {
            return this.listenersVar;
        }

        public int listenersLengthVar() {
            return this.listenersLengthVar;
        }

        public int iVar() {
            return this.iVar;
        }

        public Label getForStartLabel() {
            return this.forStartLabel;
        }

        public Label getForEndLabel() {
            return this.forEndLabel;
        }

        public void addField(String name, String descriptor) {
            this.fields.put(name, descriptor);
            this.cw.visitField(18, name, descriptor, null, null);
        }

        public void writeGetField(MethodVisitor mv, String name) {
            mv.visitFieldInsn(180, this.implementationClassRawName, name, this.fields.get(name));
        }

        public void writeMethodInvoke(MethodVisitor mv) {
            mv.visitMethodInsn(185, this.typeRawName, this.listenerMethodName, DynamicInvokerFactory.this.listenerMethodType.toMethodDescriptorString(), true);
        }
    }

    public record ParamTable(int localStart, List<LocalEntry> params) {
    }

    public record LocalEntry(int index, Class<?> type) {
    }
}

