/*
 * Decompiled with CFR 0.152.
 */
package net.mani.sethome;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SetHome
implements ModInitializer {
    public static final String MOD_ID = "sethome";
    public static final Logger LOGGER = Logger.getLogger("sethome");
    private static final Gson GSON = new Gson();
    private static final Path SAVE_PATH = Path.of("config/sethome_data.json", new String[0]);
    public static final Map<UUID, Map<String, class_2338>> homePositions = new HashMap<UUID, Map<String, class_2338>>();
    public static final SuggestionProvider<class_2168> HOME_SUGGESTIONS = (context, builder) -> {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        Map<String, class_2338> homes = homePositions.get(player.method_5667());
        if (homes != null) {
            class_2172.method_9265(homes.keySet(), (SuggestionsBuilder)builder);
        }
        return builder.buildFuture();
    };

    public void onInitialize() {
        SetHome.loadHomes();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)MOD_ID).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                String homeName = StringArgumentType.getString((CommandContext)ctx, (String)"name");
                class_2338 pos = player.method_24515();
                UUID uuid = player.method_5667();
                Map playerHomes = homePositions.computeIfAbsent(uuid, k -> new HashMap());
                if (!playerHomes.containsKey(homeName) && playerHomes.size() >= 3) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"You can only have up to 3 homes. Delete one before adding another."), false);
                    return 1;
                }
                playerHomes.put(homeName, pos);
                SetHome.saveHomes();
                player.method_7353((class_2561)class_2561.method_43470((String)("Home '" + homeName + "' is set.")), false);
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"removehome").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(HOME_SUGGESTIONS).executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                String homeName = StringArgumentType.getString((CommandContext)ctx, (String)"name");
                Map<String, class_2338> homes = homePositions.get(player.method_5667());
                if (homes != null && homes.containsKey(homeName)) {
                    homes.remove(homeName);
                    SetHome.saveHomes();
                    player.method_7353((class_2561)class_2561.method_43470((String)("Home '" + homeName + "' deleted.")), false);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Home '" + homeName + "' not found.")), false);
                }
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"home").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                String homeName = StringArgumentType.getString((CommandContext)ctx, (String)"name");
                Map<String, class_2338> homes = homePositions.get(player.method_5667());
                if (homes != null && homes.containsKey(homeName)) {
                    class_2338 pos = homes.get(homeName);
                    player.method_14251(player.method_51469(), (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, player.method_36454(), player.method_36455());
                    player.method_7353((class_2561)class_2561.method_43470((String)("Teleported to home '" + homeName + "'.")), false);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Home '" + homeName + "' not found. Use /sethome <name> to create one.")), false);
                }
                return 1;
            })));
        });
    }

    public static void saveHomes() {
        try {
            Files.createDirectories(SAVE_PATH.getParent(), new FileAttribute[0]);
            HashMap data = new HashMap();
            for (Map.Entry<UUID, Map<String, class_2338>> playerEntry : homePositions.entrySet()) {
                HashMap<String, int[]> homes = new HashMap<String, int[]>();
                for (Map.Entry<String, class_2338> homeEntry : playerEntry.getValue().entrySet()) {
                    class_2338 pos = homeEntry.getValue();
                    homes.put(homeEntry.getKey(), new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()});
                }
                data.put(playerEntry.getKey().toString(), homes);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(SAVE_PATH, new OpenOption[0]);){
                GSON.toJson(data, (Appendable)writer);
            }
            LOGGER.info("Saved " + data.size() + " players' homes.");
        }
        catch (IOException e) {
            LOGGER.warning("Failed to save homes: " + e.getMessage());
        }
    }

    public static void loadHomes() {
        if (Files.exists(SAVE_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(SAVE_PATH);){
                Type type = new TypeToken<Map<String, Map<String, int[]>>>(){}.getType();
                Map data = (Map)GSON.fromJson((Reader)reader, type);
                homePositions.clear();
                for (Map.Entry playerEntry : data.entrySet()) {
                    UUID uuid = UUID.fromString((String)playerEntry.getKey());
                    HashMap<String, class_2338> homes = new HashMap<String, class_2338>();
                    for (Map.Entry homeEntry : ((Map)playerEntry.getValue()).entrySet()) {
                        int[] pos = (int[])homeEntry.getValue();
                        homes.put((String)homeEntry.getKey(), new class_2338(pos[0], pos[1], pos[2]));
                    }
                    homePositions.put(uuid, homes);
                }
                LOGGER.info("Loaded " + homePositions.size() + " players' homes.");
            }
            catch (IOException e) {
                LOGGER.warning("Failed to load homes: " + e.getMessage());
            }
        }
    }
}

