/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.class_1074;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.JadeIds;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.overlay.DisplayHelper;

public class ArmorElement
extends Element {
    public static final class_2960 ARMOR = class_2960.method_60656((String)"hud/armor_full");
    public static final class_2960 HALF_ARMOR = class_2960.method_60656((String)"hud/armor_half");
    public static final class_2960 EMPTY_ARMOR = class_2960.method_60656((String)"hud/armor_empty");
    private final float armor;
    private String text;
    private int iconsPerLine = 1;
    private int lineCount = 1;
    private int iconCount = 1;

    public ArmorElement(float armor) {
        this.armor = armor;
        if (armor > (float)PluginConfig.INSTANCE.getInt(JadeIds.MC_ENTITY_ARMOR_MAX_FOR_RENDER)) {
            if (!PluginConfig.INSTANCE.get(JadeIds.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
                armor = class_3532.method_15386((float)armor);
            }
            this.text = DisplayHelper.dfCommas.format(armor);
        } else {
            int maxHeartsPerLine = PluginConfig.INSTANCE.getInt(JadeIds.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            this.iconCount = class_3532.method_15386((float)(armor *= 0.5f));
            this.iconsPerLine = Math.min(maxHeartsPerLine, this.iconCount);
            this.lineCount = class_3532.method_15386((float)(armor / (float)maxHeartsPerLine));
        }
    }

    @Override
    public class_241 getSize() {
        if (this.showText()) {
            class_327 font = class_310.method_1551().field_1772;
            return new class_241((float)(font.method_1727(this.text) + 10), 9.0f);
        }
        return new class_241((float)(8 * this.iconsPerLine + 1), (float)(5 + 4 * this.lineCount));
    }

    @Override
    public void render(class_332 guiGraphics, float x, float y, float maxX, float maxY) {
        IDisplayHelper helper = IDisplayHelper.get();
        int xOffset = (this.iconCount - 1) % this.iconsPerLine * 8;
        int yOffset = this.lineCount * 4 - 4;
        for (int i = this.iconCount; i > 0; --i) {
            helper.blitSprite(guiGraphics, EMPTY_ARMOR, (int)(x + (float)xOffset), (int)(y + (float)yOffset), 9, 9);
            if (i <= class_3532.method_15375((float)this.armor)) {
                helper.blitSprite(guiGraphics, ARMOR, (int)(x + (float)xOffset), (int)(y + (float)yOffset), 9, 9);
            }
            if ((float)i > this.armor && (float)i < this.armor + 1.0f) {
                helper.blitSprite(guiGraphics, HALF_ARMOR, (int)(x + (float)xOffset), (int)(y + (float)yOffset), 9, 9);
            }
            if ((xOffset -= 8) >= 0) continue;
            xOffset = this.iconsPerLine * 8 - 8;
            yOffset -= 4;
        }
        if (this.showText()) {
            helper.drawText(guiGraphics, this.text, x + 10.0f, y + 1.0f, IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    @Nullable
    public String getMessage() {
        return class_1074.method_4662((String)"narration.jade.armor", (Object[])new Object[]{class_3532.method_15386((float)this.armor)});
    }

    public boolean showText() {
        return this.text != null;
    }
}

