/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.core;

import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.level.ExplosionEvents;
import fuzs.puzzleslib.api.event.v1.server.ServerLifecycleEvents;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLevelEvents;
import fuzs.puzzleslib.fabric.impl.event.FabricEventImplHelper;
import fuzs.puzzleslib.fabric.impl.event.SpawnTypeMob;
import fuzs.puzzleslib.impl.core.EventHandlerProvider;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalEntityTypeTags;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3281;
import net.minecraft.class_3288;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7699;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class FabricAbstractions
implements CommonAbstractions,
EventHandlerProvider {
    private final Set<String> hiddenPacks = Sets.newConcurrentHashSet();
    private MinecraftServer gameServer;

    @Override
    public void registerEventHandlers() {
        ServerLifecycleEvents.STARTING.register(EventPhase.FIRST, server -> {
            this.gameServer = server;
        });
        ServerLifecycleEvents.STOPPED.register(EventPhase.LAST, server -> {
            this.gameServer = null;
        });
    }

    @Override
    public MinecraftServer getMinecraftServer() {
        return this.gameServer;
    }

    @Override
    public boolean hasChannel(class_3222 serverPlayer, class_8710.class_9154<?> type) {
        return serverPlayer.field_13987 != null && ServerPlayNetworking.canSend((class_3222)serverPlayer, type);
    }

    @Override
    public void openMenu(class_3222 player, final class_3908 menuProvider, final BiConsumer<class_3222, class_9129> dataWriter) {
        player.method_17355((class_3908)new ExtendedScreenHandlerFactory<class_9129>(){

            public class_9129 getScreenOpeningData(class_3222 player) {
                class_9129 buf = new class_9129(Unpooled.buffer(), player.method_56673());
                dataWriter.accept(player, buf);
                return buf;
            }

            public class_2561 method_5476() {
                return menuProvider.method_5476();
            }

            @Nullable
            public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                return menuProvider.createMenu(i, inventory, player);
            }
        });
    }

    @Override
    public class_1297 getPartEntityParent(class_1297 entity) {
        class_1297 class_12972;
        if (entity instanceof class_1508) {
            class_1508 enderDragonPart = (class_1508)entity;
            class_12972 = enderDragonPart.field_7007;
        } else {
            class_12972 = entity;
        }
        return class_12972;
    }

    @Override
    public boolean isBossMob(class_1299<?> type) {
        return type.method_20210(ConventionalEntityTypeTags.BOSSES);
    }

    @Override
    public float getEnchantPowerBonus(class_2680 state, class_1937 level, class_2338 pos) {
        return state.method_26164(class_3481.field_44472) ? 1.0f : 0.0f;
    }

    @Override
    public boolean canEquip(class_1799 stack, class_1304 slot, class_1309 entity) {
        return slot == entity.method_32326(stack);
    }

    @Override
    public int getMobLootingLevel(class_1297 target, @Nullable class_1297 attacker, @Nullable class_1282 damageSource) {
        int enchantmentLevel = CommonAbstractions.super.getMobLootingLevel(target, attacker, damageSource);
        if (!(target instanceof class_1309)) {
            return enchantmentLevel;
        }
        class_1309 livingEntity = (class_1309)target;
        class_6880<class_1887> enchantment = LookupHelper.lookupEnchantment(target, (class_5321<class_1887>)class_1893.field_9110);
        return FabricEventImplHelper.onComputeEnchantedLootBonus(enchantment, enchantmentLevel, livingEntity, damageSource);
    }

    @Override
    public boolean getMobGriefingRule(class_1937 level, @Nullable class_1297 entity) {
        return level.method_8450().method_8355(class_1928.field_19388);
    }

    @Override
    public void onPlayerDestroyItem(class_1657 player, class_1799 originalItemStack, @Nullable class_1268 interactionHand) {
    }

    @Override
    @Nullable
    public class_3730 getMobSpawnType(class_1308 mob) {
        return ((SpawnTypeMob)mob).puzzleslib$getSpawnType();
    }

    @Override
    public class_3288.class_7679 createPackInfo(class_2960 id, class_2561 description, class_3281 packCompatibility, class_7699 features, boolean hidden) {
        if (hidden) {
            this.hiddenPacks.add(id.toString());
        }
        return new class_3288.class_7679(description, packCompatibility, features, Collections.emptyList());
    }

    public boolean notHidden(String id) {
        return !this.hiddenPacks.contains(id);
    }

    @Override
    public boolean canApplyAtEnchantingTable(class_6880<class_1887> enchantment, class_1799 itemStack) {
        return itemStack.canBeEnchantedWith(enchantment, EnchantingContext.PRIMARY);
    }

    @Override
    public boolean isBookEnchantable(class_1799 inputStack, class_1799 bookStack) {
        return true;
    }

    @Override
    public boolean onExplosionStart(class_1937 level, class_1927 explosion) {
        return ((ExplosionEvents.Start)FabricLevelEvents.EXPLOSION_START.invoker()).onExplosionStart(level, explosion).isInterrupt();
    }
}

