/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.event;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedInt;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.event.v1.entity.living.AnimalTameCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.ComputeEnchantedLootBonusCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingBreathEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLivingEvents;
import fuzs.puzzleslib.fabric.impl.event.CapturedDropsEntity;
import java.util.Collection;
import java.util.OptionalInt;
import net.minecraft.class_1282;
import net.minecraft.class_1292;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_47;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class FabricEventImplHelper {
    private FabricEventImplHelper() {
    }

    public static int onAnimalTame(class_1429 animal, class_1657 player, int intValue) {
        return FabricEventImplHelper.onAnimalTame(animal, player, intValue, 1, intValue == 0);
    }

    public static int onAnimalTame(class_1429 animal, class_1657 player, int intValue, int returnValue, boolean tameCondition) {
        if (tameCondition && ((AnimalTameCallback)FabricLivingEvents.ANIMAL_TAME.invoker()).onAnimalTame(animal, player).isInterrupt()) {
            return returnValue;
        }
        return intValue;
    }

    public static int onComputeEnchantedLootBonus(class_6880<class_1887> enchantment, int enchantmentLevel, class_47 lootContext) {
        class_1297 entity = (class_1297)lootContext.method_296(class_181.field_1226);
        if (!(entity instanceof class_1309)) {
            return enchantmentLevel;
        }
        class_1309 livingEntity = (class_1309)entity;
        class_1282 damageSource = (class_1282)lootContext.method_296(class_181.field_1231);
        return FabricEventImplHelper.onComputeEnchantedLootBonus(enchantment, enchantmentLevel, livingEntity, damageSource);
    }

    public static int onComputeEnchantedLootBonus(class_6880<class_1887> enchantment, int enchantmentLevel, class_1309 livingEntity, @Nullable class_1282 damageSource) {
        MutableInt mutableInt = MutableInt.fromValue(enchantmentLevel);
        ((ComputeEnchantedLootBonusCallback)FabricLivingEvents.COMPUTE_ENCHANTED_LOOT_BONUS.invoker()).onComputeEnchantedLootBonus(livingEntity, damageSource, enchantment, mutableInt);
        return mutableInt.getAsInt();
    }

    public static boolean tryOnLivingDrops(class_1309 entity, class_1282 damageSource, int lastHurtByPlayerTime) {
        Collection<class_1542> capturedDrops = ((CapturedDropsEntity)entity).puzzleslib$acceptCapturedDrops(null);
        if (capturedDrops != null) {
            EventResult result = ((LivingDropsCallback)FabricLivingEvents.LIVING_DROPS.invoker()).onLivingDrops(entity, damageSource, capturedDrops, lastHurtByPlayerTime > 0);
            if (result.isPass()) {
                capturedDrops.forEach(itemEntity -> entity.method_37908().method_8649((class_1297)itemEntity));
            }
            return true;
        }
        return false;
    }

    public static void tickAirSupply(class_1309 entity, int originalAirSupply, boolean canRefillAir, boolean tryDrown) {
        boolean canLoseAir = !entity.method_6094() && !class_1292.method_5574((class_1309)entity) && (!(entity instanceof class_1657) || !((class_1657)entity).method_31549().field_7480);
        FabricEventImplHelper.tickAirSupply(entity, originalAirSupply, canRefillAir, canLoseAir, tryDrown);
    }

    public static void tickAirSupply(class_1309 entity, int originalAirSupply, boolean canRefillAir, boolean canLoseAir, boolean tryDrown) {
        DefaultedInt airAmount = DefaultedInt.fromValue(entity.method_5669() - originalAirSupply);
        EventResult result = ((LivingBreathEvents.Breathe)FabricLivingEvents.LIVING_BREATHE.invoker()).onLivingBreathe(entity, airAmount, canRefillAir, canLoseAir);
        if (result.isInterrupt()) {
            entity.method_5855(originalAirSupply);
        } else {
            OptionalInt optional = airAmount.getAsOptionalInt();
            if (optional.isPresent()) {
                entity.method_5855(Math.min(originalAirSupply + optional.getAsInt(), entity.method_5748()));
            }
        }
        if (tryDrown) {
            FabricEventImplHelper.tryDrownEntity(entity);
        }
    }

    private static void tryDrownEntity(class_1309 entity) {
        if (entity.method_5669() > 0) {
            return;
        }
        boolean isDrowning = entity.method_5669() <= -20;
        EventResult result = ((LivingBreathEvents.Drown)FabricLivingEvents.LIVING_DROWN.invoker()).onLivingDrown(entity, entity.method_5669(), isDrowning);
        if (result.isInterrupt()) {
            isDrowning = result.getAsBoolean();
        }
        if (isDrowning) {
            entity.method_5855(0);
            class_243 deltaMovement = entity.method_18798();
            for (int i = 0; i < 8; ++i) {
                double offsetX = entity.method_59922().method_43058() - entity.method_59922().method_43058();
                double offsetY = entity.method_59922().method_43058() - entity.method_59922().method_43058();
                double offsetZ = entity.method_59922().method_43058() - entity.method_59922().method_43058();
                entity.method_37908().method_8406((class_2394)class_2398.field_11247, entity.method_23317() + offsetX, entity.method_23318() + offsetY, entity.method_23321() + offsetZ, deltaMovement.field_1352, deltaMovement.field_1351, deltaMovement.field_1350);
            }
            entity.method_5643(entity.method_48923().method_48824(), 2.0f);
        }
    }
}

