/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.init;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.ModLoader;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.init.v3.registry.RegistryHelper;
import fuzs.puzzleslib.api.init.v3.registry.RegistryManager;
import fuzs.puzzleslib.impl.init.LazyHolder;
import fuzs.puzzleslib.impl.item.CreativeModeTabHelper;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.apache.commons.lang3.StringUtils;

public abstract class RegistryManagerImpl
implements RegistryManager {
    protected final String modId;
    protected Set<ModLoader> allowedModLoaders = EnumSet.allOf(ModLoader.class);

    protected RegistryManagerImpl(String modId) {
        this.modId = modId;
    }

    @Override
    public class_2960 makeKey(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("path is invalid");
        }
        return ResourceLocationHelper.fromNamespaceAndPath(this.modId, path);
    }

    @Override
    public RegistryManager whenOn(ModLoader ... allowedModLoaders) {
        Preconditions.checkState((allowedModLoaders.length > 0 ? 1 : 0) != 0, (Object)"mod loaders is empty");
        this.allowedModLoaders = EnumSet.copyOf(Arrays.asList(allowedModLoaders));
        return this;
    }

    @Override
    public <T> class_6880.class_6883<T> registerLazily(class_5321<? extends class_2378<? super T>> registryKey, String path) {
        class_2378 registry = RegistryHelper.findBuiltInRegistry(registryKey);
        class_5321 resourceKey = this.makeResourceKey(registryKey, path);
        return new LazyHolder(registryKey, resourceKey, () -> {
            class_6880.class_6883 holder = registry.method_40290(resourceKey);
            if (!holder.method_40227()) {
                Object value = registry.method_29107(resourceKey);
                Objects.requireNonNull(value, "value is null");
                holder.method_45918(value);
            }
            return holder;
        });
    }

    @Override
    public final <T> class_6880.class_6883<T> register(class_5321<? extends class_2378<? super T>> registryKey, String path, Supplier<T> supplier) {
        return this.register(registryKey, path, supplier, false);
    }

    public final <T> class_6880.class_6883<T> register(class_5321<? extends class_2378<? super T>> registryKey, String path, Supplier<T> supplier, boolean skipRegistration) {
        Objects.requireNonNull(registryKey, "registry key is null");
        Objects.requireNonNull(supplier, "supplier is null");
        class_6880.class_6883<T> holder = !this.allowedModLoaders.contains((Object)ModLoaderEnvironment.INSTANCE.getModLoader()) ? this.registerLazily(registryKey, path) : this.getHolderReference(registryKey, path, supplier, skipRegistration);
        this.allowedModLoaders = EnumSet.allOf(ModLoader.class);
        return holder;
    }

    protected abstract <T> class_6880.class_6883<T> getHolderReference(class_5321<? extends class_2378<? super T>> var1, String var2, Supplier<T> var3, boolean var4);

    @Override
    public class_6880.class_6883<class_1761> registerCreativeModeTab(String path, Supplier<class_1799> iconSupplier, class_1761.class_7914 displayItems, boolean withSearchBar) {
        return this.register(class_7924.field_44688, path, () -> {
            class_1761.class_7913 builder = this.getCreativeModeTabBuilder(withSearchBar);
            class_2960 resourceLocation = this.makeKey(path);
            builder.method_47321(CreativeModeTabHelper.getTitle(resourceLocation));
            builder.method_47320(iconSupplier);
            builder.method_47317(displayItems);
            return builder.method_47324();
        });
    }

    protected abstract class_1761.class_7913 getCreativeModeTabBuilder(boolean var1);
}

