/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.events;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.ListMode;
import com.b1n_ry.yigd.events.AllowBlockUnderGraveGenerationEvent;
import com.b1n_ry.yigd.events.AllowGraveGenerationEvent;
import com.b1n_ry.yigd.events.DropItemEvent;
import com.b1n_ry.yigd.events.DropRuleEvent;
import com.b1n_ry.yigd.events.GraveClaimEvent;
import com.b1n_ry.yigd.events.GraveGenerationEvent;
import com.b1n_ry.yigd.util.DropRule;
import com.b1n_ry.yigd.util.GraveCompassHelper;
import com.b1n_ry.yigd.util.GraveOverrideAreas;
import com.b1n_ry.yigd.util.YigdTags;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.PermissionCheckEvent;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1291;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class YigdServerEventHandler {
    public static void registerEventCallbacks() {
        YigdServerEventHandler.registerPermissionEvents();
        DropRuleEvent.EVENT.register((item, slot, context, modify) -> {
            YigdConfig config = YigdConfig.getConfig();
            class_1291 statusEffect = (class_1291)class_7923.field_41174.method_10223(class_2960.method_60655((String)"amethyst_imbuement", (String)"soulbinding"));
            class_6880 statusEffectEntry = class_7923.field_41174.method_47983((Object)statusEffect);
            if (config.inventoryConfig.soulboundSlots.contains(slot)) {
                return DropRule.KEEP;
            }
            if (config.inventoryConfig.vanishingSlots.contains(slot)) {
                return DropRule.DESTROY;
            }
            if (config.inventoryConfig.dropOnGroundSlots.contains(slot)) {
                return DropRule.DROP;
            }
            if (item.method_31573(YigdTags.NATURAL_SOULBOUND)) {
                return DropRule.KEEP;
            }
            if (item.method_31573(YigdTags.NATURAL_VANISHING)) {
                return DropRule.DESTROY;
            }
            if (item.method_31573(YigdTags.GRAVE_INCOMPATIBLE)) {
                return DropRule.DROP;
            }
            if (statusEffect != null && context != null && context.player().method_6059(statusEffectEntry)) {
                return DropRule.KEEP;
            }
            if (!item.method_7960() && item.method_57826(class_9334.field_49628)) {
                class_9279 nbt = (class_9279)item.method_57824(class_9334.field_49628);
                assert (nbt != null);
                class_2487 itemNbt = nbt.method_57461();
                if (itemNbt.method_10545("Botania_keepIvy") && itemNbt.method_10577("Botania_keepIvy")) {
                    if (modify) {
                        class_9279 replaced = nbt.method_57451(nbtCompound -> nbtCompound.method_10551("Botania_keepIvy"));
                        item.method_57379(class_9334.field_49628, (Object)replaced);
                    }
                    return DropRule.KEEP;
                }
            }
            DropRule dropRule = context != null ? GraveOverrideAreas.INSTANCE.getDropRuleFromArea(class_2338.method_49638((class_2374)context.deathPos()), context.world()) : GraveOverrideAreas.INSTANCE.defaultDropRule;
            if (class_1890.method_60138((class_1799)item, YigdTags.VANISHING)) {
                return DropRule.DESTROY;
            }
            if (class_1890.method_60138((class_1799)item, YigdTags.SOULBOUND)) {
                if (config.inventoryConfig.loseSoulboundLevelOnDeath) {
                    for (class_6880 enchantmentRegistryEntry : class_1890.method_57532((class_1799)item).method_57534()) {
                        if (!enchantmentRegistryEntry.method_40220(YigdTags.SOULBOUND)) continue;
                        int level = class_1890.method_8225((class_6880)enchantmentRegistryEntry, (class_1799)item);
                        if (level > 1) {
                            class_1890.method_57531((class_1799)item, builder -> builder.method_57547(enchantmentRegistryEntry, level - 1));
                            continue;
                        }
                        class_1890.method_57531((class_1799)item, builder -> builder.method_57548(enchant -> enchant.equals((Object)enchantmentRegistryEntry)));
                    }
                }
                return DropRule.KEEP;
            }
            return dropRule;
        });
        GraveClaimEvent.EVENT.register((player, world, pos, grave, tool) -> {
            if (player.method_29504()) {
                return false;
            }
            YigdConfig config = YigdConfig.getConfig();
            if (config.extraFeatures.graveCompass.consumeOnUse || config.extraFeatures.graveCompass.pointToClosest != YigdConfig.ExtraFeatures.GraveCompassConfig.CompassGraveTarget.DISABLED) {
                class_1661 inventory = player.method_31548();
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    class_1799 stack = inventory.method_5438(i);
                    if (!stack.method_31574(class_1802.field_8251)) continue;
                    if (config.extraFeatures.graveCompass.consumeOnUse) {
                        UUID graveId;
                        class_2487 stackNbt;
                        class_9279 stackNbtComponent = (class_9279)stack.method_57824(class_9334.field_49628);
                        class_2487 class_24872 = stackNbt = stackNbtComponent != null ? stackNbtComponent.method_57461() : null;
                        if (!stack.method_31574(class_1802.field_8251) || stackNbt == null || !stackNbt.method_10545("linked_grave") || !(graveId = stackNbt.method_25926("linked_grave")).equals(grave.getGraveId())) continue;
                        stack.method_7939(0);
                        break;
                    }
                    GraveCompassHelper.updateClosestNbt((class_5321<class_1937>)world.method_27983(), player.method_24515(), player.method_5667(), stack);
                }
            }
            if (config.extraFeatures.graveKeys.enabled) {
                if (tool.method_31574((class_1792)Yigd.GRAVE_KEY_ITEM)) {
                    class_9279 nbtComponent = (class_9279)tool.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
                    class_2487 nbt = nbtComponent.method_57461();
                    class_2487 userNbt = nbt.method_10562("user");
                    class_2520 uuidNbt = nbt.method_10580("grave");
                    YigdConfig.ExtraFeatures.GraveKeyConfig.KeyTargeting targeting = config.extraFeatures.graveKeys.targeting;
                    switch (targeting) {
                        case ANY_GRAVE: {
                            tool.method_7934(1);
                            return true;
                        }
                        case PLAYER_GRAVE: {
                            if (!Objects.equals(class_9296.field_49359.parse((DynamicOps)class_2509.field_11560, (Object)userNbt).result().orElse(null), grave.getOwner())) break;
                            tool.method_7934(1);
                            return true;
                        }
                        case SPECIFIC_GRAVE: {
                            if (uuidNbt == null || !Objects.equals(class_2512.method_25930((class_2520)uuidNbt), grave.getGraveId())) break;
                            tool.method_7934(1);
                            return true;
                        }
                    }
                }
                if (config.extraFeatures.graveKeys.required) {
                    player.method_43502((class_2561)class_2561.method_43471((String)"text.yigd.message.missing_key"), true);
                    return false;
                }
            }
            if (config.graveConfig.requireShovelToLoot && !tool.method_31573(class_3489.field_42615)) {
                player.method_43502((class_2561)class_2561.method_43471((String)"text.yigd.message.no_shovel"), true);
                return false;
            }
            if (player.method_5667().equals(grave.getOwner().comp_2411().orElse(null))) {
                return true;
            }
            if (!grave.isLocked()) {
                return true;
            }
            YigdConfig.GraveConfig.GraveRobbing robConfig = config.graveConfig.graveRobbing;
            if (!robConfig.enabled) {
                return false;
            }
            if (robConfig.killerSkipWaitTime && player.method_5667().equals(grave.getKillerId())) {
                return true;
            }
            int tps = 20;
            if (!grave.hasExistedTicks(robConfig.timeUnit.toSeconds(robConfig.afterTime) * 20L)) {
                player.method_43502((class_2561)class_2561.method_43469((String)"text.yigd.message.rob.too_early", (Object[])new Object[]{grave.getTimeUntilRobbable()}), true);
                return false;
            }
            return true;
        });
        AllowGraveGenerationEvent.EVENT.register((context, grave) -> {
            YigdConfig.GraveConfig graveConfig = YigdConfig.getConfig().graveConfig;
            if (!graveConfig.enabled) {
                return false;
            }
            if (DeathInfoManager.INSTANCE.getGraveListMode() == ListMode.WHITELIST && !DeathInfoManager.INSTANCE.isInList(new class_9296(context.player().method_7334())) || DeathInfoManager.INSTANCE.getGraveListMode() == ListMode.BLACKLIST && DeathInfoManager.INSTANCE.isInList(new class_9296(context.player().method_7334()))) {
                Yigd.LOGGER.info("{} found on whitelist/blacklist, disallowing grave generation", (Object)context.player().method_7334().getName());
            }
            if (!graveConfig.generateEmptyGraves && grave.isGraveEmpty()) {
                return false;
            }
            if (graveConfig.dimensionBlacklist.contains(grave.getWorldRegistryKey().method_29177().toString())) {
                return false;
            }
            if (!graveConfig.generateGraveInVoid && grave.getPos().method_10264() < context.world().method_31607()) {
                return false;
            }
            if (graveConfig.requireItem) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)graveConfig.requiredItem));
                if (!grave.getInventoryComponent().removeItem(stack -> stack.method_31574(item), graveConfig.requiredItemCount)) {
                    return false;
                }
            }
            return !graveConfig.ignoredDeathTypes.contains(context.deathSource().method_5525());
        });
        AllowBlockUnderGraveGenerationEvent.EVENT.register((grave, currentUnder) -> YigdConfig.getConfig().graveConfig.blockUnderGrave.enabled && currentUnder.method_26164(YigdTags.REPLACE_SOFT_WHITELIST));
        GraveGenerationEvent.EVENT.register((world, pos, nthTry) -> {
            if (world.method_31606(pos) || !world.method_8621().method_11952(pos)) {
                return false;
            }
            class_2680 state = world.method_8320(pos);
            YigdConfig.GraveConfig config = YigdConfig.getConfig().graveConfig;
            if (world.method_8321(pos) != null) {
                return false;
            }
            switch (nthTry) {
                case 0: {
                    if (!config.useSoftBlockWhitelist) {
                        return false;
                    }
                    if (state.method_26164(YigdTags.REPLACE_SOFT_WHITELIST)) break;
                    return false;
                }
                case 1: {
                    if (!config.useStrictBlockBlacklist) {
                        return false;
                    }
                    if (!state.method_26164(YigdTags.KEEP_STRICT_BLACKLIST)) break;
                    return false;
                }
            }
            return true;
        });
        DropItemEvent.EVENT.register((stack, x, y, z, world) -> !stack.method_7960());
    }

    private static void registerPermissionEvents() {
        PermissionCheckEvent.EVENT.register((source, permission) -> {
            if (permission.equals("yigd.command.locking") && !YigdConfig.getConfig().graveConfig.unlockable) {
                return TriState.FALSE;
            }
            return TriState.DEFAULT;
        });
    }
}

