/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.config;

import com.aizistral.nochatreports.common.NCRCore;
import com.aizistral.nochatreports.common.config.ServerAddressAdapter;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_639;

public abstract class JSONConfig {
    protected static final Path CONFIG_DIR = NCRCore.getProvider().getConfigDir();
    protected static final Gson GSON = JSONConfig.createGson();
    protected final String fileName;
    protected final Path filePath;

    protected JSONConfig(String file) {
        this.fileName = file;
        this.filePath = CONFIG_DIR.resolve(this.fileName);
    }

    public Path getFile() {
        return this.filePath;
    }

    public void saveFile() {
        NCRCore.LOGGER.debug("Writing config file {}...", (Object)this.fileName);
        JSONConfig.writeFile(this.fileName, this);
    }

    protected void uponLoad() {
    }

    public abstract JSONConfig getDefault();

    public static <T extends JSONConfig> T loadConfig(Class<T> configClass, Supplier<T> freshInstance, String fileName) {
        NCRCore.LOGGER.debug("Reading config file {}...", (Object)fileName);
        JSONConfig config = (JSONConfig)JSONConfig.readFile(fileName, configClass).orElseGet(freshInstance);
        config.uponLoad();
        return (T)config;
    }

    private static <T extends JSONConfig> Optional<T> readFile(String fileName, Class<T> configClass) {
        Optional<JSONConfig> optional;
        block9: {
            Path file = CONFIG_DIR.resolve(fileName);
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                return Optional.empty();
            }
            BufferedReader reader = Files.newBufferedReader(file);
            try {
                optional = Optional.of((JSONConfig)GSON.fromJson((Reader)reader, configClass));
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    NCRCore.LOGGER.fatal("Could not read config file: {}", (Object)file);
                    NCRCore.LOGGER.fatal("This likely indicates the file is corrupted. You can try deleting it to fix this problem. Full stacktrace below:");
                    NCRCore.LOGGER.catching((Throwable)ex);
                    throw new RuntimeException("Could not read config file: " + String.valueOf(file), ex);
                }
            }
            reader.close();
        }
        return optional;
    }

    private static <T> void writeFile(String fileName, T config) {
        Path file = CONFIG_DIR.resolve(fileName);
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                GSON.toJson(config, (Appendable)writer);
            }
        }
        catch (Exception ex) {
            NCRCore.LOGGER.fatal("Could not write config file: {}", (Object)file);
            NCRCore.LOGGER.fatal("Full stacktrace below:");
            NCRCore.LOGGER.catching((Throwable)ex);
            throw new RuntimeException("Could not write config file: " + String.valueOf(file), ex);
        }
    }

    private static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes field) {
                return field.getDeclaringClass() == JSONConfig.class;
            }

            public boolean shouldSkipClass(Class<?> theClass) {
                return false;
            }
        }});
        if (NCRCore.getProvider().isOnClient()) {
            builder.registerTypeAdapter(class_639.class, (Object)ServerAddressAdapter.INSTANCE);
        }
        return builder.create();
    }
}

