/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.utils;

import com.sonicether.soundphysics.Loggers;
import com.sonicether.soundphysics.SoundPhysicsMod;
import com.sonicether.soundphysics.profiling.TaskProfiler;
import com.sonicether.soundphysics.world.CachingClientLevel;
import com.sonicether.soundphysics.world.ClientLevelProxy;
import com.sonicether.soundphysics.world.ClonedClientLevel;
import com.sonicether.soundphysics.world.UnsafeClientLevel;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class LevelAccessUtils {
    private static final TaskProfiler PROFILER = new TaskProfiler("Level Caching");
    private static final class_310 MC = class_310.method_1551();

    public static void onLoadLevel(class_638 clientLevel) {
        Loggers.logDebug("Creating initial level cache", new Object[0]);
        LevelAccessUtils.updateLevelCache(clientLevel, LevelAccessUtils.levelOriginFromPlayer(), clientLevel.method_8510());
    }

    public static void onUnloadLevel(class_638 clientLevel) {
        Loggers.logDebug("Removing level cache due to level unload", new Object[0]);
        ((CachingClientLevel)clientLevel).sound_physics_remastered$setCachedClone(null);
    }

    public static void tickLevelCache(class_638 clientLevel) {
        if (!SoundPhysicsMod.CONFIG.enabled.get().booleanValue()) {
            return;
        }
        if (SoundPhysicsMod.CONFIG.unsafeLevelAccess.get().booleanValue()) {
            return;
        }
        long currentTick = clientLevel.method_8510();
        class_2338 origin = LevelAccessUtils.levelOriginFromPlayer();
        CachingClientLevel cachingClientLevel = (CachingClientLevel)clientLevel;
        ClonedClientLevel clientLevelClone = cachingClientLevel.sound_physics_remastered$getCachedClone();
        if (clientLevelClone == null) {
            Loggers.logDebug("Creating new level cache, no existing level clone found in client cache.", new Object[0]);
            LevelAccessUtils.updateLevelCache(clientLevel, origin, SoundPhysicsMod.CONFIG.levelCloneMaxRetainTicks.get().intValue());
            return;
        }
        long ticksSinceLastClone = currentTick - clientLevelClone.getTick();
        double distanceSinceLastClone = origin.method_10262((class_2382)clientLevelClone.getOrigin());
        if (ticksSinceLastClone >= (long)SoundPhysicsMod.CONFIG.levelCloneMaxRetainTicks.get().intValue() || distanceSinceLastClone >= (double)SoundPhysicsMod.CONFIG.levelCloneMaxRetainBlockDistance.get().intValue()) {
            Loggers.logDebug("Updating level cache, cache expired ({}/{} ticks) or player moved too far ({}/{} block(s)) from last clone origin.", ticksSinceLastClone, SoundPhysicsMod.CONFIG.levelCloneMaxRetainTicks.get(), distanceSinceLastClone, SoundPhysicsMod.CONFIG.levelCloneMaxRetainBlockDistance.get());
            LevelAccessUtils.updateLevelCache(clientLevel, origin, currentTick);
        }
    }

    private static void updateLevelCache(class_638 clientLevel, class_2338 origin, long tick) {
        Loggers.logDebug("Updating level cache, creating new level clone with origin {} on tick {}.", origin.method_23854(), tick);
        TaskProfiler.TaskProfilerHandle profile = PROFILER.profile();
        CachingClientLevel cachingClientLevel = (CachingClientLevel)clientLevel;
        ClonedClientLevel clientLevelClone = new ClonedClientLevel(clientLevel, origin, tick, SoundPhysicsMod.CONFIG.levelCloneRange.get());
        cachingClientLevel.sound_physics_remastered$setCachedClone(clientLevelClone);
        profile.finish();
        Loggers.logProfiling("Updated client level clone in cache in {} ms", profile.getDuration());
        PROFILER.onTally(PROFILER::logResults);
    }

    @Nullable
    public static ClientLevelProxy getClientLevelProxy(class_310 client) {
        class_638 clientLevel = client.field_1687;
        if (clientLevel == null) {
            Loggers.warn("Can not return client level proxy, client level does not exist.", new Object[0]);
            return null;
        }
        if (SoundPhysicsMod.CONFIG.unsafeLevelAccess.get().booleanValue()) {
            return new UnsafeClientLevel(clientLevel);
        }
        CachingClientLevel cachingClientLevel = (CachingClientLevel)clientLevel;
        ClonedClientLevel clientLevelClone = cachingClientLevel.sound_physics_remastered$getCachedClone();
        if (clientLevelClone == null) {
            Loggers.warn("Can not return client level proxy, client level clone has not been cached. This might only occur once on load.", new Object[0]);
            return null;
        }
        return clientLevelClone;
    }

    private static class_2338 levelOriginFromPlayer() {
        class_243 playerPos = LevelAccessUtils.MC.field_1724.method_19538();
        return class_2338.method_49638((class_2374)playerPos);
    }
}

