/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.renderer;

import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TargetArrowRenderer {
    private static final float[] PYRAMID_STRIP = new float[]{0.0f, -1.0f, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f, -1.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, -1.0f, 1.0f, -1.0f, 0.0f, -1.0f, -1.0f, 0.0f};
    private static final float[] PYRAMID_COLORS = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static final float PYRAMID_ALPHA = 0.75f;
    private static final Vector3f PYRAMID_UP = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final int TICKS_TO_ACTIVATE = 40;
    public static double[] TX = new double[]{-0.25, -0.15};
    public static double[] TY = new double[]{0.15, 0.25};
    public static double[] TZ = new double[]{0.0, 0.0};
    public static float SX = 0.015f;
    public static float SY = 0.045f;
    public static float SZ = 0.03f;
    private Vector3f direction = new Vector3f();
    private Vector3f[] partialDirection = new Vector3f[]{new Vector3f(), new Vector3f()};
    private Quaternionf[] rotation = new Quaternionf[]{new Quaternionf(), new Quaternionf()};
    private Quaternionf[] localY = new Quaternionf[]{new Quaternionf(), new Quaternionf()};
    private int activationTicks;
    private int ticks;
    private class_1297 source;
    private class_243 target;
    private boolean otherDim;
    private int activeTicks;
    private static final TargetArrowRenderer INSTANCE = new TargetArrowRenderer();

    public static TargetArrowRenderer getInstance() {
        return INSTANCE;
    }

    public void tick() {
        if (this.hasTarget()) {
            this.updateDirection();
            if (this.activationTicks < 40) {
                ++this.activationTicks;
            }
            if (--this.activeTicks < 0) {
                this.setTarget(null, null, false);
            }
        } else if (this.activationTicks > 0) {
            --this.activationTicks;
        }
        if (++this.ticks < 0) {
            this.ticks = 0;
        }
    }

    public void render(class_4588 buffer, class_4587 poseStack, boolean lefthand) {
        if (this.activationTicks > 0) {
            class_310 mc = class_310.method_1551();
            class_4184 cam = mc.field_1773.method_19418();
            if (cam.method_19332()) {
                float partialTick = class_310.method_1551().method_60646().method_60637(false);
                float t = Math.min((float)this.activationTicks + partialTick, 40.0f) / 40.0f;
                int ti = lefthand ? 0 : 1;
                this.partialDirection[ti].lerp((Vector3fc)this.direction, Math.min(0.05f, 0.2f * partialTick));
                PYRAMID_UP.rotationTo((Vector3fc)this.partialDirection[ti], this.rotation[ti]);
                poseStack.method_22903();
                poseStack.method_22904(TX[ti], TY[ti], TZ[ti]);
                poseStack.method_22907(cam.method_23767().difference((Quaternionfc)this.rotation[ti], this.rotation[ti]));
                poseStack.method_22907(this.localY[ti].identity().rotateLocalY((float)Math.PI * ((float)this.ticks + partialTick) / 40.0f));
                poseStack.method_22905(SX * t, (float)((double)SY + Math.sin(((float)this.ticks + partialTick) / 10.0f) * 0.01) * t, SZ * t);
                poseStack.method_22907(this.localY[ti].identity().rotateLocalY(0.7853982f));
                Matrix4f m = poseStack.method_23760().method_23761();
                for (int i = 0; i < PYRAMID_STRIP.length; i += 3) {
                    buffer.method_22918(m, PYRAMID_STRIP[i], PYRAMID_STRIP[i + 1], PYRAMID_STRIP[i + 2]).method_22915(PYRAMID_COLORS[i], PYRAMID_COLORS[i + 1], PYRAMID_COLORS[i + 2], 0.75f * t);
                }
                poseStack.method_22909();
            }
        }
    }

    public void setTarget(class_1297 source, class_243 target, boolean otherDim) {
        this.source = source;
        this.target = target;
        this.otherDim = otherDim;
        this.activeTicks = 20;
    }

    public boolean hasTarget() {
        return this.source != null && this.target != null;
    }

    private void updateDirection() {
        if (!this.otherDim) {
            this.direction.lerp((Vector3fc)this.target.method_1020(this.source.method_19538()).method_46409(), 0.2f);
        } else {
            double t = Math.PI * (double)this.ticks / 20.0;
            this.direction.lerp((Vector3fc)new Vector3f((float)Math.sin(t), (float)Math.cos(t), 0.0f), 0.05f);
        }
    }
}

