/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.screens.widgets.controls;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7172;

public class CycleButton<T>
extends class_4264 {
    private final class_2561 name;
    private int index;
    private T value;
    private final List<T> values;
    private final Function<T, class_2561> valueStringifier;
    private final Function<CycleButton<T>, class_5250> narrationProvider;
    private final BiConsumer<CycleButton<T>, T> onValueChange;
    private final boolean displayOnlyValue;
    private final class_7172.class_7277<T> tooltipSupplier;

    public static <T> CycleButton<T> create(Function<T, class_2561> componentFunc, List<T> values, int selected, int x, int y, int w, int h, boolean onlyValue) {
        selected = values.size() > 0 ? class_3532.method_15387((int)selected, (int)values.size()) : -1;
        T value = values.size() > 0 ? (T)values.get(selected) : null;
        class_5250 prefix = class_2561.method_43473();
        class_5250 component = values.size() > 0 ? CycleButton.createLabelForValue(value, (class_2561)prefix, onlyValue, componentFunc) : class_2561.method_43473();
        return new CycleButton<Object>(x, y, w, h, (class_2561)component, (class_2561)prefix, selected, value, values, componentFunc, c -> (class_5250)c.method_25369(), (c, v) -> {}, v -> null, onlyValue);
    }

    CycleButton(int i, int j, int k, int l, class_2561 component, class_2561 component2, int m, T object, List<T> values, Function<T, class_2561> function, Function<CycleButton<T>, class_5250> function2, BiConsumer<CycleButton<T>, T> onValueChange, class_7172.class_7277<T> tooltipSupplier, boolean bl) {
        super(i, j, k, l, component);
        this.name = component2;
        this.index = m;
        this.value = object;
        this.values = values;
        this.valueStringifier = function;
        this.narrationProvider = function2;
        this.onValueChange = onValueChange;
        this.displayOnlyValue = bl;
        this.tooltipSupplier = tooltipSupplier;
        this.updateTooltip();
    }

    private void updateTooltip() {
        this.method_47400(this.tooltipSupplier.apply(this.value));
    }

    public void method_25306() {
        if (class_437.method_25442()) {
            this.cycleValue(-1);
        } else {
            this.cycleValue(1);
        }
    }

    private void cycleValue(int i) {
        List<T> list = this.values;
        this.index = class_3532.method_15387((int)(this.index + i), (int)list.size());
        T object = list.get(this.index);
        this.updateValue(object);
        this.onValueChange.accept(this, (CycleButton)((Object)object));
    }

    private T getCycledValue(int i) {
        List<T> list = this.values;
        return list.get(class_3532.method_15387((int)(this.index + i), (int)list.size()));
    }

    public boolean method_25401(double d, double e, double f, double g) {
        if (g > 0.0) {
            this.cycleValue(-1);
        } else if (g < 0.0) {
            this.cycleValue(1);
        }
        return true;
    }

    public void setValue(T object) {
        List<T> list = this.values;
        int i = list.indexOf(object);
        if (i != -1) {
            this.index = i;
        }
        this.updateValue(object);
    }

    public boolean setValue(int i) {
        if ((i = Math.min(i, this.values.size() - 1)) >= 0) {
            this.index = i;
            this.updateValue(this.values.get(i));
            return true;
        }
        return false;
    }

    public void addValue(T object) {
        this.values.add(object);
    }

    private void updateValue(T object) {
        class_2561 component = this.createLabelForValue(object);
        this.method_25355(component);
        this.value = object;
        this.updateTooltip();
    }

    private class_2561 createLabelForValue(T object) {
        return this.displayOnlyValue ? this.valueStringifier.apply(object) : this.createFullName(object);
    }

    private class_5250 createFullName(T object) {
        return class_5244.method_32700((class_2561)this.name, (class_2561)this.valueStringifier.apply(object));
    }

    private static <T> class_2561 createLabelForValue(T object, class_2561 name, boolean displayOnlyValue, Function<T, class_2561> valueStringifier) {
        return displayOnlyValue ? valueStringifier.apply(object) : CycleButton.createFullName(object, name, valueStringifier);
    }

    private static <T> class_5250 createFullName(T object, class_2561 name, Function<T, class_2561> valueStringifier) {
        return class_5244.method_32700((class_2561)name, (class_2561)valueStringifier.apply(object));
    }

    public T getValue() {
        return this.value;
    }

    public int getIndex() {
        return this.index;
    }

    protected class_5250 method_25360() {
        return this.narrationProvider.apply(this);
    }

    public void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
        if (this.field_22763) {
            T object = this.getCycledValue(1);
            class_2561 component = this.createLabelForValue(object);
            if (this.method_25370()) {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43469((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{component}));
            } else {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43469((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{component}));
            }
        }
    }

    public class_5250 createDefaultNarrationMessage() {
        return CycleButton.method_32602((class_2561)(this.displayOnlyValue ? this.createFullName(this.value) : this.method_25369()));
    }
}

