/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconProperties;
import dev.ftb.mods.ftblibrary.icon.MutableColor4I;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_757;
import net.minecraft.class_9801;

public class BulletIcon
extends Icon {
    private static final MutableColor4I DEFAULT_COLOR = Color4I.rgb(0xEDEDED).mutable();
    private static final MutableColor4I DEFAULT_COLOR_B = Color4I.rgb(0xFFFFFF).mutable();
    private static final MutableColor4I DEFAULT_COLOR_D = Color4I.rgb(0xDDDDDD).mutable();
    private Color4I color = Icon.empty();
    private Color4I colorB = Icon.empty();
    private Color4I colorD = Icon.empty();
    private boolean inverse = false;

    @Override
    public BulletIcon copy() {
        BulletIcon icon = new BulletIcon();
        icon.color = this.color;
        icon.colorB = this.colorB;
        icon.colorD = this.colorD;
        icon.inverse = this.inverse;
        return icon;
    }

    public BulletIcon setColor(Color4I col) {
        this.color = col;
        if (this.color.isEmpty()) {
            return this;
        }
        MutableColor4I c = this.color.mutable();
        c.addBrightness(18);
        this.colorB = c.copy();
        c = this.color.mutable();
        c.addBrightness(-18);
        this.colorD = c.copy();
        return this;
    }

    @Override
    public BulletIcon withColor(Color4I col) {
        return this.copy().setColor(col);
    }

    @Override
    public BulletIcon withTint(Color4I c) {
        return this.withColor(this.color.withTint(c));
    }

    public BulletIcon setInverse(boolean v) {
        this.inverse = v;
        return this;
    }

    @Override
    protected void setProperties(IconProperties properties) {
        super.setProperties(properties);
        this.inverse = properties.getBoolean("inverse", this.inverse);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void draw(class_332 graphics, int x, int y, int w, int h) {
        Color4I cd;
        Color4I cb;
        Color4I c;
        if (this.color.isEmpty()) {
            c = DEFAULT_COLOR;
            cb = DEFAULT_COLOR_B;
            cd = DEFAULT_COLOR_D;
        } else {
            c = this.color;
            cb = this.colorB;
            cd = this.colorD;
        }
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        GuiHelper.addRectToBuffer(graphics, buffer, x, y + 1, 1, h - 2, this.inverse ? cd : cb);
        GuiHelper.addRectToBuffer(graphics, buffer, x + w - 1, y + 1, 1, h - 2, this.inverse ? cb : cd);
        GuiHelper.addRectToBuffer(graphics, buffer, x + 1, y, w - 2, 1, this.inverse ? cd : cb);
        GuiHelper.addRectToBuffer(graphics, buffer, x + 1, y + h - 1, w - 2, 1, this.inverse ? cb : cd);
        GuiHelper.addRectToBuffer(graphics, buffer, x + 1, y + 1, w - 2, h - 2, c);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.addProperty("id", "bullet");
        if (!this.color.isEmpty()) {
            o.add("color", this.color.getJson());
        }
        return o;
    }
}

