/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.icon.PartIcon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanStack;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class Theme {
    public static final Theme DEFAULT = new Theme();
    public static final int DARK = 1;
    public static final int SHADOW = 2;
    public static final int CENTERED = 4;
    public static final int UNICODE = 8;
    public static final int MOUSE_OVER = 16;
    public static final int CENTERED_V = 32;
    public static final ImageIcon BACKGROUND_SQUARES = (ImageIcon)Icon.getIcon("ftblibrary:textures/gui/background_squares.png");
    private static final Color4I CONTENT_COLOR_MOUSE_OVER = Color4I.rgb(0xFFFFA0);
    private static final Color4I CONTENT_COLOR_DISABLED = Color4I.rgb(0xA0A0A0);
    private static final Color4I CONTENT_COLOR_DARK = Color4I.rgb(0x404040);
    private static final ImageIcon TEXTURE_BEACON = (ImageIcon)Icon.getIcon("textures/gui/container/beacon.png");
    private static final ImageIcon TEXTURE_RECIPE_BOOK = (ImageIcon)Icon.getIcon("textures/gui/recipe_book.png");
    private static final Icon GUI = new PartIcon("ftblibrary:textures/gui/background.png", 0, 0, 16, 16, 4, 16, 16);
    private static final Icon GUI_MOUSE_OVER = GUI.withTint(Color4I.rgb(11515610));
    private static final Icon BUTTON = PartIcon.wholeTexture("textures/gui/sprites/widget/button.png", 200, 20, 4);
    private static final Icon BUTTON_MOUSE_OVER = PartIcon.wholeTexture("textures/gui/sprites/widget/button_highlighted.png", 200, 20, 4);
    private static final Icon BUTTON_DISABLED = PartIcon.wholeTexture("textures/gui/sprites/widget/button_disabled.png", 200, 20, 4);
    private static final Icon WIDGET = PartIcon.wholeTexture("textures/gui/sprites/container/beacon/button.png", 22, 22, 4);
    private static final Icon WIDGET_MOUSE_OVER = PartIcon.wholeTexture("textures/gui/sprites/container/beacon/button_highlighted.png", 22, 22, 4);
    private static final Icon WIDGET_DISABLED = PartIcon.wholeTexture("textures/gui/sprites/container/beacon/button_disabled.png", 22, 22, 4);
    private static final Icon SCROLLER = PartIcon.wholeTexture("textures/gui/sprites/widget/slider_handle.png", 8, 20, 2);
    private static final Icon SCROLLER_MOUSE_OVER = PartIcon.wholeTexture("textures/gui/sprites/widget/slider_handle_highlighted.png", 8, 20, 2);
    private static final Icon SLOT = new PartIcon(TEXTURE_BEACON, 35, 136, 18, 18, 3);
    private static final Icon SLOT_MOUSE_OVER = SLOT.combineWith((Icon)Color4I.WHITE.withAlpha(33));
    private static final Icon SCROLL_BAR_BG = SLOT;
    private static final Icon SCROLL_BAR_BG_DISABLED = SCROLL_BAR_BG.withTint(Color4I.BLACK.withAlpha(100));
    private static final Icon TEXT_BOX = PartIcon.wholeTexture("textures/gui/sprites/container/enchanting_table/enchantment_slot_disabled.png", 108, 19, 4);
    private static final Icon TAB_H_UNSELECTED = PartIcon.wholeTexture("textures/gui/sprites/widget/tab.png", 130, 24, 2);
    private static final Icon TAB_H_SELECTED = PartIcon.wholeTexture("textures/gui/sprites/widget/tab_selected.png", 130, 24, 2);
    public static boolean renderDebugBoxes = false;
    private final BooleanStack fontUnicode = new BooleanArrayList();

    public Color4I getContentColor(WidgetType type) {
        return type == WidgetType.MOUSE_OVER ? CONTENT_COLOR_MOUSE_OVER : (type == WidgetType.DISABLED ? CONTENT_COLOR_DISABLED : Color4I.WHITE);
    }

    public Color4I getInvertedContentColor() {
        return CONTENT_COLOR_DARK;
    }

    public void drawGui(class_332 graphics, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.MOUSE_OVER ? GUI_MOUSE_OVER : GUI).draw(graphics, x - 3, y - 3, w + 6, h + 6);
    }

    public void drawWidget(class_332 graphics, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.MOUSE_OVER ? WIDGET_MOUSE_OVER : (type == WidgetType.DISABLED ? WIDGET_DISABLED : WIDGET)).draw(graphics, x, y, w, h);
    }

    public void drawSlot(class_332 graphics, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.MOUSE_OVER ? SLOT_MOUSE_OVER : SLOT).draw(graphics, x, y, w, h);
    }

    public void drawContainerSlot(class_332 graphics, int x, int y, int w, int h) {
        SLOT.draw(graphics, x - 1, y - 1, w + 2, h + 2);
    }

    public void drawButton(class_332 graphics, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.MOUSE_OVER ? BUTTON_MOUSE_OVER : (type == WidgetType.DISABLED ? BUTTON_DISABLED : BUTTON)).draw(graphics, x, y, w, h);
    }

    public void drawScrollBarBackground(class_332 graphics, int x, int y, int w, int h, WidgetType type) {
        (type == WidgetType.DISABLED ? SCROLL_BAR_BG_DISABLED : SCROLL_BAR_BG).draw(graphics, x, y, w, h);
    }

    public void drawScrollBar(class_332 graphics, int x, int y, int w, int h, WidgetType type, boolean vertical) {
        (type == WidgetType.MOUSE_OVER ? SCROLLER_MOUSE_OVER : SCROLLER).draw(graphics, x + 1, y + 1, w - 2, h - 2);
    }

    public void drawTextBox(class_332 graphics, int x, int y, int w, int h) {
        TEXT_BOX.draw(graphics, x, y, w, h);
    }

    public void drawCheckboxBackground(class_332 graphics, int x, int y, int w, int h, boolean radioButton) {
        this.drawSlot(graphics, x, y, w, h, WidgetType.NORMAL);
    }

    public void drawCheckbox(class_332 graphics, int x, int y, int w, int h, WidgetType type, boolean selected, boolean radioButton) {
        if (selected) {
            this.drawWidget(graphics, x, y, w, h, type);
        }
    }

    public void drawPanelBackground(class_332 graphics, int x, int y, int w, int h) {
        Color4I.rgb(0x8B8B8B).draw(graphics, x, y, w, h);
    }

    public void drawHorizontalTab(class_332 graphics, int x, int y, int w, int h, boolean selected) {
        (selected ? TAB_H_SELECTED : TAB_H_UNSELECTED).draw(graphics, x, y, w, h);
    }

    public void drawContextMenuBackground(class_332 graphics, int x, int y, int w, int h) {
        this.drawGui(graphics, x, y, w, h, WidgetType.NORMAL);
        Color4I.BLACK.withAlpha(90).draw(graphics, x, y, w, h);
    }

    public class_327 getFont() {
        return class_310.method_1551().field_1772;
    }

    public final int getStringWidth(class_5348 text) {
        return text == class_2561.field_25310 ? 0 : this.getFont().method_27525(text);
    }

    public final int getStringWidth(class_5481 text) {
        return text == class_5481.field_26385 ? 0 : this.getFont().method_30880(text);
    }

    public final int getStringWidth(String text) {
        return text.isEmpty() ? 0 : this.getFont().method_1727(text);
    }

    public final int getFontHeight() {
        Objects.requireNonNull(this.getFont());
        return 9;
    }

    public final String trimStringToWidth(String text, int width) {
        return text.isEmpty() || width <= 0 ? "" : this.getFont().method_27524(text, width, false);
    }

    public final class_5348 trimStringToWidth(class_5348 text, int width) {
        return this.getFont().method_1714(text, width);
    }

    public final String trimStringToWidthReverse(String text, int width) {
        return text.isEmpty() || width <= 0 ? "" : this.getFont().method_27524(text, width, true);
    }

    public final List<class_5348> listFormattedStringToWidth(class_5348 text, int width) {
        if (width <= 0 || text == class_2561.field_25310) {
            return Collections.emptyList();
        }
        return this.getFont().method_27527().method_27495(text, width, class_2583.field_24360);
    }

    public final int drawString(class_332 graphics, @Nullable Object text, int x, int y, Color4I color, int flags) {
        String s;
        if (text == null || text == class_5481.field_26385 || text == class_2561.field_25310 || text instanceof String && (s = (String)text).isEmpty() || color.isEmpty()) {
            return x;
        }
        Object object = text;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_5481.class, class_2561.class, class_5348.class}, (Object)object2, n)) {
            case 0: {
                class_5481 fcs = (class_5481)object2;
                if (Bits.getFlag(flags, 4)) {
                    x -= this.getStringWidth(fcs) / 2;
                }
                int i = graphics.method_51430(this.getFont(), (class_5481)text, x, y, color.rgba(), Bits.getFlag(flags, 2));
                GuiHelper.setupDrawing();
                return i;
            }
            case 1: {
                class_2561 comp = (class_2561)object2;
                if (Bits.getFlag(flags, 4)) {
                    x -= this.getStringWidth((class_5348)comp) / 2;
                }
                int i = graphics.method_51439(this.getFont(), comp, x, y, color.rgba(), Bits.getFlag(flags, 2));
                GuiHelper.setupDrawing();
                return i;
            }
            case 2: {
                class_5348 formattedText = (class_5348)object2;
                return this.drawString(graphics, class_2477.method_10517().method_30934(formattedText), x, y, color, flags);
            }
        }
        String s2 = String.valueOf(text);
        if (Bits.getFlag(flags, 4)) {
            x -= this.getStringWidth(s2) / 2;
        }
        int i = graphics.method_51433(this.getFont(), s2, x, y, color.rgba(), Bits.getFlag(flags, 2));
        GuiHelper.setupDrawing();
        return i;
    }

    public final int drawString(class_332 graphics, @Nullable Object text, int x, int y, int flags) {
        return this.drawString(graphics, text, x, y, this.getContentColor(WidgetType.mouseOver(Bits.getFlag(flags, 16))), flags);
    }

    public final int drawString(class_332 graphics, @Nullable Object text, int x, int y) {
        return this.drawString(graphics, text, x, y, this.getContentColor(WidgetType.NORMAL), 0);
    }
}

