/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.experimental.lai;

import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;

final class ActionKeys {
    static String switchKey(ActiveBattlePokemon from, BattlePokemon to) {
        return String.format("s|%s|%s|%s", !from.isAlive() ? null : from.getBattlePokemon().getOriginalPokemon().getSpecies().getName(), to.getOriginalPokemon().getSpecies().getName(), from.getSide().getOppositeSide().getActivePokemon().stream().filter(ActiveBattlePokemon::isAlive).map(p -> p.getBattlePokemon().getOriginalPokemon().getSpecies().getName()).reduce("", (n1, n2) -> n2 + "," + n1));
    }

    static String itemKey(BagItem item, BattlePokemon target) {
        return String.format("i|%s|%s|%.1f", item.getItemName(), target.getOriginalPokemon().getSpecies().getName(), Float.valueOf((float)target.getHealth() / (float)target.getMaxHealth()));
    }

    static String moveKey(ActiveBattlePokemon pkmn, InBattleMove move, Targetable target) {
        return String.format("m|%s|%s|%s|%s", pkmn.getBattlePokemon().getOriginalPokemon().getSpecies().getName(), move.id, target != null ? target.getPNX() : "null", pkmn.getSide().getOppositeSide().getActivePokemon().stream().filter(ActiveBattlePokemon::isAlive).map(p -> p.getBattlePokemon().getOriginalPokemon().getSpecies().getName()).reduce("", (n1, n2) -> n2 + "," + n1));
    }

    static String switchFuzzyKey(ActiveBattlePokemon from, BattlePokemon to) {
        StringBuilder fromTypes = new StringBuilder();
        StringBuilder toTypes = new StringBuilder();
        StringBuilder oppositeTypes = new StringBuilder();
        if (!from.isGone()) {
            for (ElementalType t : from.getBattlePokemon().getOriginalPokemon().getTypes()) {
                if (!fromTypes.isEmpty()) {
                    fromTypes.append(',');
                }
                fromTypes.append(t.getName());
            }
        } else {
            fromTypes.append("null");
        }
        for (ElementalType t : to.getOriginalPokemon().getTypes()) {
            if (!toTypes.isEmpty()) {
                toTypes.append(',');
            }
            toTypes.append(t.getName());
        }
        from.getSide().getOppositeSide().getActivePokemon().stream().filter(ActiveBattlePokemon::isAlive).map(ActiveBattlePokemon::getBattlePokemon).forEach(pkmn -> {
            for (ElementalType t : pkmn.getOriginalPokemon().getTypes()) {
                if (!oppositeTypes.isEmpty()) {
                    oppositeTypes.append(',');
                }
                oppositeTypes.append(t.getName());
            }
        });
        return String.format("sf|%s|%s|%s", fromTypes.toString(), toTypes.toString(), oppositeTypes.toString());
    }

    static String itemFuzzyKey(BagItem item, BattlePokemon target) {
        return String.format("if|%s|%.1f", item.getItemName(), Float.valueOf((float)target.getHealth() / (float)target.getMaxHealth()));
    }

    static String moveFuzzyKey(ActiveBattlePokemon pkmn, InBattleMove move, Targetable target) {
        StringBuilder fromTypes = new StringBuilder();
        StringBuilder targetTypes = new StringBuilder();
        if (!pkmn.isGone()) {
            for (ElementalType t : pkmn.getBattlePokemon().getOriginalPokemon().getTypes()) {
                if (!fromTypes.isEmpty()) {
                    fromTypes.append(',');
                }
                fromTypes.append(t.getName());
            }
        } else {
            fromTypes.append("null");
        }
        if (target != null) {
            for (Targetable obj : target.getActorPokemon()) {
                ActiveBattlePokemon targetPkmn = (ActiveBattlePokemon)obj;
                if (!targetPkmn.isAlive()) continue;
                for (ElementalType t : targetPkmn.getBattlePokemon().getOriginalPokemon().getTypes()) {
                    if (!targetTypes.isEmpty()) {
                        targetTypes.append(',');
                    }
                    targetTypes.append(t.getName());
                }
            }
        } else {
            targetTypes.append("null");
        }
        return String.format("mf|%s|%s|%s", fromTypes.toString(), Moves.INSTANCE.getByName(move.id).getElementalType().getName(), targetTypes.toString());
    }

    private ActionKeys() {
    }
}

