/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.mixins.client;

import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.SingleActionRequest;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.battle.BattleGUI;
import com.cobblemon.mod.common.client.gui.battle.subscreen.BattleActionSelection;
import com.gitlab.srcmc.rctapi.client.ClientTasks;
import com.gitlab.srcmc.rctapi.client.ModClient;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BattleGUI.class})
public abstract class BattleGUIMixin
implements CobblemonRenderable {
    private static final long MAX_SELECT_DELAY = 32000L;

    @Shadow(remap=false)
    abstract void changeActionSelection(@Nullable BattleActionSelection var1);

    @Inject(method={"selectAction"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void injectSelectAction(@NotNull SingleActionRequest request, @Nullable ShowdownActionResponse response, CallbackInfo ci) {
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (Stream.of(battle.getSides()).anyMatch(s -> s.getActors().stream().anyMatch(a -> a.getType().equals((Object)ActorType.NPC)))) {
            if (battle != null && request.getResponse() == null) {
                request.setResponse(response);
                this.changeActionSelection(null);
                if (request.getForceSwitch() && ModClient.BATTLE_STATE.getFainted()) {
                    ClientTasks.BATTLE_SELECTIONS.runIf(() -> battle.checkForFinishedChoosing(), () -> !ModClient.BATTLE_STATE.getForceSwitch() || ModClient.BATTLE_STATE.getDispatchesComplete(), 32000L);
                } else {
                    battle.checkForFinishedChoosing();
                }
            }
            ci.cancel();
        }
    }
}

