/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.inventorytweaks.features.sort;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.anvian.inventorytweaks.InventoryTweak;
import net.anvian.inventorytweaks.config.ModConfig;
import net.anvian.inventorytweaks.handler.Interaction;
import net.anvian.inventorytweaks.slots.ContainerSlots;
import net.anvian.inventorytweaks.slots.InventorySlots;
import net.anvian.inventorytweaks.slots.PlayerSlots;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class SortInventory {
    public static void sortPlayerInventory(class_1703 screenHandler) {
        if (SortInventory.cursorCleared(PlayerSlots.get(), screenHandler)) {
            SortInventory.mergeItemStacks(PlayerSlots.get().excludeOffhand(), screenHandler);
            SortInventory.sortItemStacks(PlayerSlots.get().excludeOffhand(), screenHandler);
        }
    }

    public static void sortContainerInventory(class_1703 screenHandler) {
        if (SortInventory.cursorCleared(ContainerSlots.get(), screenHandler)) {
            SortInventory.mergeItemStacks(ContainerSlots.get(), screenHandler);
            SortInventory.sortItemStacks(ContainerSlots.get(), screenHandler);
        }
    }

    private static boolean cursorCleared(InventorySlots inventorySlots, class_1703 screenHandler) {
        if (!Interaction.hasEmptyCursor()) {
            SortInventory.clearCursor(inventorySlots, screenHandler);
        }
        return Interaction.hasEmptyCursor();
    }

    private static void mergeItemStacks(InventorySlots inventorySlots, class_1703 screenHandler) {
        Iterator iterator = inventorySlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            class_1799 stack = screenHandler.method_7611(slot).method_7677();
            if (stack.method_7960() || stack.method_7947() >= stack.method_7914()) continue;
            Interaction.clickStack(slot);
            for (int tempSlot = slot + 1; Interaction.getCursorStack().method_7947() < Interaction.getCursorStack().method_7914() && tempSlot <= inventorySlots.getLastSlot() && !Interaction.getCursorStack().method_7960(); ++tempSlot) {
                if (!class_1799.method_7984((class_1799)Interaction.getCursorStack(), (class_1799)screenHandler.method_7611(tempSlot).method_7677())) continue;
                Interaction.clickStack(tempSlot);
            }
            if (Interaction.hasEmptyCursor()) continue;
            Interaction.clickStack(slot);
        }
    }

    private static void sortItemStacks(InventorySlots inventorySlots, class_1703 screenHandler) {
        List<Integer> sortedSlots = SortInventory.getSortedSlots(inventorySlots, screenHandler);
        for (int i = 0; i < sortedSlots.size(); ++i) {
            Interaction.swapStacks(sortedSlots.get(i), (Integer)inventorySlots.get(i));
            sortedSlots = SortInventory.getSortedSlots(inventorySlots, screenHandler);
        }
    }

    private static List<Integer> getSortedSlots(InventorySlots inventorySlots, class_1703 screenHandler) {
        return switch (InventoryTweak.CONFIG.sortType()) {
            default -> throw new MatchException(null, null);
            case ModConfig.SortType.NAME -> inventorySlots.stream().filter(slot -> !screenHandler.method_7611(slot.intValue()).method_7677().method_7960()).sorted(Comparator.comparing(slot -> screenHandler.method_7611(slot.intValue()).method_7677().method_7964().getString()).thenComparing(slot -> screenHandler.method_7611(slot.intValue()).method_7677().method_7947(), Comparator.reverseOrder())).toList();
            case ModConfig.SortType.TYPE -> inventorySlots.stream().filter(slot -> !screenHandler.method_7611(slot.intValue()).method_7677().method_7960()).sorted(Comparator.comparing(slot -> class_1792.method_7880((class_1792)screenHandler.method_7611(slot.intValue()).method_7677().method_7909())).thenComparing(slot -> screenHandler.method_7611(slot.intValue()).method_7677().method_7964().getString()).thenComparing(slot -> screenHandler.method_7611(slot.intValue()).method_7677().method_7947(), Comparator.reverseOrder())).toList();
            case ModConfig.SortType.RARITY -> inventorySlots.stream().filter(slot -> !screenHandler.method_7611(slot.intValue()).method_7677().method_7960()).sorted(Comparator.comparing(slot -> screenHandler.method_7611(slot.intValue()).method_7677().method_7932()).reversed().thenComparing(slot -> screenHandler.method_7611(slot.intValue()).method_7677().method_7964().getString()).thenComparing(slot -> screenHandler.method_7611(slot.intValue()).method_7677().method_7947(), Comparator.reverseOrder())).toList();
        };
    }

    private static void clearCursor(InventorySlots inventorySlots, class_1703 screenHandler) {
        int slot;
        Iterator iterator = inventorySlots.iterator();
        while (iterator.hasNext()) {
            slot = (Integer)iterator.next();
            if (!class_1799.method_7984((class_1799)screenHandler.method_7611(slot).method_7677(), (class_1799)Interaction.getCursorStack()) || Interaction.hasEmptyCursor()) continue;
            Interaction.clickStack(slot);
        }
        iterator = inventorySlots.iterator();
        while (iterator.hasNext()) {
            slot = (Integer)iterator.next();
            if (!screenHandler.method_7611(slot).method_7677().method_7960() || Interaction.hasEmptyCursor()) continue;
            Interaction.clickStack(slot);
        }
    }
}

