/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.md.features;

import io.wispforest.lavender.md.ItemListComponent;
import io.wispforest.lavender.md.compiler.BookCompiler;
import io.wispforest.lavender.pond.SmithingRecipeAccessor;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_2561;
import net.minecraft.class_2952;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8059;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeFeature
implements MarkdownFeature {
    private final BookCompiler.ComponentSource bookComponentSource;
    private final Map<class_3956<?>, RecipePreviewBuilder<?>> previewBuilders;
    public static final RecipePreviewBuilder<class_3955> CRAFTING_PREVIEW_BUILDER = new RecipePreviewBuilder<class_3955>(){

        @Override
        @NotNull
        public Component buildRecipePreview(BookCompiler.ComponentSource componentSource, class_8786<class_3955> recipeEntry) {
            ParentComponent recipeComponent = componentSource.builtinTemplate(ParentComponent.class, "crafting-recipe");
            this.populateIngredientsGrid(recipeEntry, (List<class_1856>)((class_3955)recipeEntry.comp_1933()).method_8117(), (ParentComponent)recipeComponent.childById(ParentComponent.class, "input-grid"), 3, 3);
            ((ItemComponent)recipeComponent.childById(ItemComponent.class, "output")).stack(((class_3955)recipeEntry.comp_1933()).method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()));
            return recipeComponent;
        }
    };
    public static final RecipePreviewBuilder<class_1874> SMELTING_PREVIEW_BUILDER = (componentSource, recipeEntry) -> {
        class_1874 recipe = (class_1874)recipeEntry.comp_1933();
        ParentComponent recipeComponent = componentSource.builtinTemplate(ParentComponent.class, "smelting-recipe");
        ((ItemListComponent)recipeComponent.childById(ItemListComponent.class, "input")).ingredient((class_1856)recipe.method_8117().get(0));
        ((ItemComponent)recipeComponent.childById(ItemComponent.class, "output")).stack(recipe.method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()));
        class_1799 workstation = class_1799.field_8037;
        if (recipe instanceof class_3861) {
            workstation = class_1802.field_8732.method_7854();
        }
        if (recipe instanceof class_3859) {
            workstation = class_1802.field_16306.method_7854();
        }
        if (recipe instanceof class_3862) {
            workstation = class_1802.field_16309.method_7854();
        }
        if (recipe instanceof class_3920) {
            workstation = class_1802.field_17346.method_7854();
        }
        ((ItemComponent)recipeComponent.childById(ItemComponent.class, "workstation")).stack(workstation);
        return recipeComponent;
    };
    public static final RecipePreviewBuilder<class_8059> SMITHING_PREVIEW_BUILDER = (componentSource, recipeEntry) -> {
        class_8059 recipe = (class_8059)recipeEntry.comp_1933();
        ParentComponent recipeComponent = componentSource.builtinTemplate(ParentComponent.class, "smithing-recipe");
        if (recipe instanceof SmithingRecipeAccessor) {
            SmithingRecipeAccessor accessor = (SmithingRecipeAccessor)recipe;
            ((ItemListComponent)recipeComponent.childById(ItemListComponent.class, "input-1")).ingredient(accessor.lavender$getTemplate());
            ((ItemListComponent)recipeComponent.childById(ItemListComponent.class, "input-2")).ingredient(accessor.lavender$getBase());
            ((ItemListComponent)recipeComponent.childById(ItemListComponent.class, "input-3")).ingredient(accessor.lavender$getAddition());
        }
        ((ItemComponent)recipeComponent.childById(ItemComponent.class, "output")).stack(recipe.method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()));
        return recipeComponent;
    };
    public static final RecipePreviewBuilder<class_3975> STONECUTTING_PREVIEW_BUILDER = (componentSource, recipeEntry) -> {
        class_3975 recipe = (class_3975)recipeEntry.comp_1933();
        ParentComponent recipeComponent = componentSource.builtinTemplate(ParentComponent.class, "stonecutting-recipe");
        ((ItemListComponent)recipeComponent.childById(ItemListComponent.class, "input")).ingredient((class_1856)recipe.method_8117().get(0));
        ((ItemComponent)recipeComponent.childById(ItemComponent.class, "output")).stack(recipe.method_8110((class_7225.class_7874)class_310.method_1551().field_1687.method_30349()));
        return recipeComponent;
    };
    @Deprecated(forRemoval=true)
    public static final RecipePreviewBuilder<class_3955> CRAFTING_HANDLER = CRAFTING_PREVIEW_BUILDER;
    @Deprecated(forRemoval=true)
    public static final RecipePreviewBuilder<class_1874> SMELTING_HANDLER = SMELTING_PREVIEW_BUILDER;
    @Deprecated(forRemoval=true)
    public static final RecipePreviewBuilder<class_8059> SMITHING_HANDLER = SMITHING_PREVIEW_BUILDER;
    @Deprecated(forRemoval=true)
    public static final RecipePreviewBuilder<class_3975> STONECUTTING_HANDLER = STONECUTTING_PREVIEW_BUILDER;

    public RecipeFeature(BookCompiler.ComponentSource bookComponentSource, @Nullable Map<class_3956<?>, RecipePreviewBuilder<?>> previewBuilders) {
        this.bookComponentSource = bookComponentSource;
        this.previewBuilders = new HashMap(previewBuilders != null ? previewBuilders : Map.of());
        this.previewBuilders.putIfAbsent(class_3956.field_17545, CRAFTING_PREVIEW_BUILDER);
        this.previewBuilders.putIfAbsent(class_3956.field_17546, SMELTING_PREVIEW_BUILDER);
        this.previewBuilders.putIfAbsent(class_3956.field_17547, SMELTING_PREVIEW_BUILDER);
        this.previewBuilders.putIfAbsent(class_3956.field_17548, SMELTING_PREVIEW_BUILDER);
        this.previewBuilders.putIfAbsent(class_3956.field_17549, SMELTING_PREVIEW_BUILDER);
        this.previewBuilders.putIfAbsent(class_3956.field_25388, SMITHING_PREVIEW_BUILDER);
        this.previewBuilders.putIfAbsent(class_3956.field_17641, STONECUTTING_PREVIEW_BUILDER);
    }

    public String name() {
        return "recipes";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof OwoUICompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("<recipe;")) {
                return false;
            }
            String recipeIdString = nibbler.consumeUntil('>');
            if (recipeIdString == null) {
                return false;
            }
            class_2960 recipeId = class_2960.method_12829((String)recipeIdString);
            if (recipeId == null) {
                return false;
            }
            Optional recipe = class_310.method_1551().field_1687.method_8433().method_8130(recipeId);
            if (recipe.isEmpty()) {
                return false;
            }
            tokens.add(new RecipeToken(recipeIdString, (class_8786)recipe.get()));
            return true;
        }, '<');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, recipeToken, tokens) -> new RecipeNode(recipeToken.recipe), (token, tokens) -> {
            RecipeToken recipe;
            return token instanceof RecipeToken ? (recipe = (RecipeToken)((Object)token)) : null;
        });
    }

    @FunctionalInterface
    public static interface RecipePreviewBuilder<R extends class_1860<?>> {
        @NotNull
        public Component buildRecipePreview(BookCompiler.ComponentSource var1, class_8786<R> var2);

        default public void populateIngredients(class_8786<R> recipe, List<class_1856> ingredients, ParentComponent componentContainer) {
            for (int i = 0; i < ingredients.size(); ++i) {
                Object e = componentContainer.children().get(i);
                if (!(e instanceof ItemListComponent)) continue;
                ItemListComponent ingredient = (ItemListComponent)((Object)e);
                ingredient.ingredient(ingredients.get(i));
            }
        }

        default public void populateIngredientsGrid(class_8786<R> recipe, List<class_1856> ingredients, ParentComponent componentContainer, int gridWidth, int gridHeight) {
            ((class_2952)(input, slot, amount, gridX, gridY) -> {
                Object patt0$temp = componentContainer.children().get(slot);
                if (!(patt0$temp instanceof ItemListComponent)) {
                    return;
                }
                ItemListComponent ingredient = (ItemListComponent)((Object)((Object)patt0$temp));
                ingredient.ingredient((class_1856)input);
            }).method_12816(gridWidth, gridHeight, 9, recipe, ingredients.iterator(), 0);
        }
    }

    private static class RecipeToken
    extends Lexer.Token {
        public final class_8786<class_1860<?>> recipe;

        public RecipeToken(String content, class_8786<class_1860<?>> recipe) {
            super(content);
            this.recipe = recipe;
        }
    }

    private class RecipeNode
    extends Parser.Node {
        private final class_8786<class_1860<?>> recipe;

        public RecipeNode(class_8786<class_1860<?>> recipe) {
            this.recipe = recipe;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            RecipePreviewBuilder<?> previewBuilder = RecipeFeature.this.previewBuilders.get(this.recipe.comp_1933().method_17716());
            if (previewBuilder != null) {
                ((OwoUICompiler)compiler).visitComponent(previewBuilder.buildRecipePreview(RecipeFeature.this.bookComponentSource, this.recipe));
            } else {
                ((OwoUICompiler)compiler).visitComponent((Component)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).child(Components.label((class_2561)class_2561.method_43470((String)("No preview builder registered for recipe type '" + String.valueOf(class_7923.field_41188.method_10221((Object)this.recipe.comp_1933().method_17716())) + "'"))).horizontalSizing(Sizing.fill((int)100))).padding(Insets.of((int)10)).surface(Surface.flat((int)0x77A00000).and(Surface.outline((int)0x77FF0000))));
            }
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }

    @Deprecated(forRemoval=true)
    public static interface RecipeHandler<R extends class_1860<?>>
    extends RecipePreviewBuilder<R> {
    }
}

