/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.commands;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.FusionData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.HeldItemData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.KeyItemData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.MegaData;
import com.cobblemon.yajatkaul.mega_showdown.datapack.data.ShowdownItemData;
import com.cobblemon.yajatkaul.mega_showdown.temp.TestCommand;
import com.cobblemon.yajatkaul.mega_showdown.utility.Utils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class MegaCommands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"msdresetlock").requires(source -> source.method_9259(0))).executes(context -> MegaCommands.executeResetCommon((class_1657)((class_2168)context.getSource()).method_44023()))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"msdresetmega").requires(source -> source.method_9259(0))).executes(context -> MegaCommands.executeResetMega((class_1657)((class_2168)context.getSource()).method_44023()))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"msd").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"itemtype", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(List.of("mega_stone", "held_item", "showdown_item", "fusion_item", "key_item"), (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"item", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            String type;
            switch (type = StringArgumentType.getString((CommandContext)context, (String)"itemtype")) {
                case "mega_stone": {
                    Utils.megaRegistry.forEach(m -> builder.suggest(m.msd_id()));
                    break;
                }
                case "held_item": {
                    Utils.heldItemsRegistry.forEach(i -> builder.suggest(i.msd_id()));
                    break;
                }
                case "showdown_item": {
                    Utils.showdownItemRegistry.forEach(i -> builder.suggest(i.msd_id()));
                    break;
                }
                case "fusion_item": {
                    Utils.fusionRegistry.forEach(f -> builder.suggest(f.msd_id()));
                    break;
                }
                case "key_item": {
                    Utils.keyItemsRegistry.forEach(k -> builder.suggest(k.msd_id()));
                }
            }
            return builder.buildFuture();
        }).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            String itemtype = StringArgumentType.getString((CommandContext)context, (String)"itemtype");
            String item = StringArgumentType.getString((CommandContext)context, (String)"item");
            return MegaCommands.executeGive(player, itemtype, item, 1);
        })).then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            String itemtype = StringArgumentType.getString((CommandContext)context, (String)"itemtype");
            String item = StringArgumentType.getString((CommandContext)context, (String)"item");
            int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
            return MegaCommands.executeGive(player, itemtype, item, count);
        }))))))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> TestCommand.register((CommandDispatcher<class_2168>)dispatcher));
    }

    private static int executeGive(class_3222 player, String itemtype, String item, int count) {
        switch (itemtype) {
            case "mega_stone": {
                for (MegaData pokemon : Utils.megaRegistry) {
                    if (!pokemon.msd_id().equals(item)) continue;
                    return MegaCommands.giveItem(player, pokemon.item_id(), pokemon.item_name(), pokemon.item_description(), pokemon.custom_model_data(), count);
                }
                break;
            }
            case "held_item": {
                for (HeldItemData held : Utils.heldItemsRegistry) {
                    if (!held.msd_id().equals(item)) continue;
                    return MegaCommands.giveItem(player, held.item_id(), held.item_name(), held.item_description(), held.custom_model_data(), count);
                }
                break;
            }
            case "showdown_item": {
                for (ShowdownItemData sd : Utils.showdownItemRegistry) {
                    if (!sd.msd_id().equals(item)) continue;
                    return MegaCommands.giveItem(player, sd.item_id(), sd.item_name(), sd.item_description(), sd.custom_model_data(), count);
                }
                break;
            }
            case "fusion_item": {
                for (FusionData fusion : Utils.fusionRegistry) {
                    if (!fusion.msd_id().equals(item)) continue;
                    return MegaCommands.giveItem(player, fusion.item_id(), fusion.item_name(), fusion.item_description(), fusion.custom_model_data(), count);
                }
                break;
            }
            case "key_item": {
                for (KeyItemData key : Utils.keyItemsRegistry) {
                    if (!key.msd_id().equals(item)) continue;
                    return MegaCommands.giveItem(player, key.item_id(), key.item_name(), key.item_description(), key.custom_model_data(), count);
                }
                break;
            }
            default: {
                player.method_7353((class_2561)class_2561.method_43470((String)("Unknown item type: " + itemtype)).method_27692(class_124.field_1061), false);
                return 0;
            }
        }
        player.method_7353((class_2561)class_2561.method_43470((String)("Item not found: " + item)).method_27692(class_124.field_1061), false);
        return 0;
    }

    private static int giveItem(class_3222 player, String itemIdStr, String itemName, List<String> description, int modelData, int count) {
        class_2960 id = class_2960.method_12829((String)itemIdStr);
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
        class_1799 stack = new class_1799((class_1935)item, count);
        stack.method_57379(class_9334.field_49637, (Object)new class_9280(modelData));
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)itemName));
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        for (String line : description) {
            lore.add(class_2561.method_43471((String)line));
        }
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
        player.method_7270(stack);
        player.method_7353((class_2561)class_2561.method_43470((String)("You received: " + itemIdStr)).method_27692(class_124.field_1060), false);
        return 1;
    }

    private static int executeResetCommon(class_1657 player) {
        PCStore storge = Cobblemon.INSTANCE.getStorage().getPC((class_3222)player);
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty((class_3222)player);
        for (Pokemon pokemon : storge) {
            if (pokemon.getAspects().contains("mega") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega_x")) {
                new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
            }
            if (!pokemon.getAspects().contains("primal")) continue;
            new StringSpeciesFeature("reversion_state", "standard").apply(pokemon);
        }
        for (Pokemon pokemon : party) {
            if (pokemon.getAspects().contains("mega") || pokemon.getAspects().contains("mega_y") || pokemon.getAspects().contains("mega_x")) {
                new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
            }
            if (!pokemon.getAspects().contains("primal")) continue;
            new StringSpeciesFeature("reversion_state", "standard").apply(pokemon);
        }
        player.method_43496((class_2561)class_2561.method_43471((String)"message.mega_showdown.reset_completed"));
        return 1;
    }

    private static int executeResetMega(class_1657 player) {
        PCStore storge = Cobblemon.INSTANCE.getStorage().getPC((class_3222)player);
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty((class_3222)player);
        for (Pokemon pokemon : storge) {
            if (!pokemon.getAspects().contains("mega") && !pokemon.getAspects().contains("mega_y") && !pokemon.getAspects().contains("mega_x")) continue;
            new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
        }
        for (Pokemon pokemon : party) {
            if (!pokemon.getAspects().contains("mega") && !pokemon.getAspects().contains("mega_y") && !pokemon.getAspects().contains("mega_x")) continue;
            new StringSpeciesFeature("mega_evolution", "none").apply(pokemon);
        }
        return 1;
    }
}

