/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl;

import eu.pb4.placeholders.api.node.KeybindNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.NbtNode;
import eu.pb4.placeholders.api.node.ScoreNode;
import eu.pb4.placeholders.api.node.SelectorNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.TranslatedNode;
import eu.pb4.placeholders.api.node.parent.ColorNode;
import eu.pb4.placeholders.api.node.parent.FormattingNode;
import eu.pb4.placeholders.api.node.parent.GradientNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.api.node.parent.StyledNode;
import java.util.ArrayList;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2572;
import net.minecraft.class_2574;
import net.minecraft.class_2578;
import net.minecraft.class_2579;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class GeneralUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Text Placeholder API");
    public static final boolean IS_DEV = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static final TextNode[] CASTER = new TextNode[0];

    public static String durationToString(long x) {
        long seconds = x % 60L;
        long minutes = x / 60L % 60L;
        long hours = x / 3600L % 24L;
        long days = x / 86400L;
        if (days > 0L) {
            return String.format("%dd%dh%dm%ds", days, hours, minutes, seconds);
        }
        if (hours > 0L) {
            return String.format("%dh%dm%ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%dm%ds", minutes, seconds);
        }
        if (seconds > 0L) {
            return String.format("%ds", seconds);
        }
        return "---";
    }

    public static boolean isEmpty(class_2561 text) {
        class_8828.class_2585 l;
        class_7417 class_74172;
        return (text.method_10851() == class_8828.field_46625 || (class_74172 = text.method_10851()) instanceof class_8828.class_2585 && (l = (class_8828.class_2585)class_74172).comp_737().isEmpty()) && text.method_10855().isEmpty();
    }

    public static class_5250 toGradient(class_2561 base, GradientNode.GradientProvider posToColor) {
        return GeneralUtils.recursiveGradient(base, posToColor, 0, GeneralUtils.getGradientLength(base)).text();
    }

    private static int getGradientLength(class_2561 base) {
        int n;
        class_7417 class_74172 = base.method_10851();
        if (class_74172 instanceof class_8828.class_2585) {
            class_8828.class_2585 l = (class_8828.class_2585)class_74172;
            n = l.comp_737().length();
        } else {
            n = base.method_10851() == class_8828.field_46625 ? 0 : 1;
        }
        int length = n;
        for (class_2561 text : base.method_10855()) {
            length += GeneralUtils.getGradientLength(text);
        }
        return length;
    }

    private static TextLengthPair recursiveGradient(class_2561 base, GradientNode.GradientProvider posToColor, int pos, int totalLength) {
        if (base.method_10866().method_10973() == null) {
            class_5250 out = class_2561.method_43473().method_10862(base.method_10866());
            class_7417 class_74172 = base.method_10851();
            if (class_74172 instanceof class_8828.class_2585) {
                class_8828.class_2585 literalTextContent = (class_8828.class_2585)class_74172;
                int l = literalTextContent.comp_737().length();
                for (int i = 0; i < l; ++i) {
                    char next;
                    int character = literalTextContent.comp_737().charAt(i);
                    int value = Character.isHighSurrogate((char)character) && i + 1 < l ? (Character.isLowSurrogate(next = literalTextContent.comp_737().charAt(++i)) ? Character.toCodePoint((char)character, next) : character) : character;
                    out.method_10852((class_2561)class_2561.method_43470((String)Character.toString(value)).method_10862(class_2583.field_24360.method_27703(posToColor.getColorAt(pos++, totalLength))));
                }
            } else {
                out.method_10852((class_2561)base.method_27662().method_10862(class_2583.field_24360.method_27703(posToColor.getColorAt(pos++, totalLength))));
            }
            for (class_2561 sibling : base.method_10855()) {
                TextLengthPair pair = GeneralUtils.recursiveGradient(sibling, posToColor, pos, totalLength);
                pos = pair.length;
                out.method_10852((class_2561)pair.text);
            }
            return new TextLengthPair(out, pos);
        }
        return new TextLengthPair(base.method_27661(), pos + base.getString().length());
    }

    public static int rgbToInt(float r, float g, float b) {
        return ((int)(r * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | (int)(b * 255.0f) & 0xFF;
    }

    public static class_2561 deepTransform(class_2561 input) {
        class_5250 output = GeneralUtils.cloneText(input);
        GeneralUtils.removeHoverAndClick(output);
        return output;
    }

    public static class_2561 removeHoverAndClick(class_2561 input) {
        class_5250 output = GeneralUtils.cloneText(input);
        GeneralUtils.removeHoverAndClick(output);
        return output;
    }

    private static void removeHoverAndClick(class_5250 input) {
        class_7417 class_74172;
        if (input.method_10866() != null) {
            input.method_10862(input.method_10866().method_10949(null).method_10958(null));
        }
        if ((class_74172 = input.method_10851()) instanceof class_2588) {
            class_2588 text = (class_2588)class_74172;
            for (int i = 0; i < text.method_11023().length; ++i) {
                Object arg = text.method_11023()[i];
                if (!(arg instanceof class_5250)) continue;
                class_5250 argText = (class_5250)arg;
                GeneralUtils.removeHoverAndClick(argText);
            }
        }
        for (class_2561 sibling : input.method_10855()) {
            GeneralUtils.removeHoverAndClick((class_5250)sibling);
        }
    }

    public static class_5250 cloneText(class_2561 input) {
        class_5250 baseText;
        class_7417 class_74172 = input.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            ArrayList<Object> obj = new ArrayList<Object>();
            for (Object arg : translatable.method_11023()) {
                if (arg instanceof class_2561) {
                    class_2561 argText = (class_2561)arg;
                    obj.add(GeneralUtils.cloneText(argText));
                    continue;
                }
                obj.add(arg);
            }
            baseText = class_2561.method_43469((String)translatable.method_11022(), (Object[])obj.toArray());
        } else {
            baseText = input.method_27662();
        }
        for (class_2561 sibling : input.method_10855()) {
            baseText.method_10852((class_2561)GeneralUtils.cloneText(sibling));
        }
        baseText.method_10862(input.method_10866());
        return baseText;
    }

    public static class_5250 cloneTransformText(class_2561 input, Function<class_5250, class_5250> transform) {
        class_5250 baseText;
        class_7417 class_74172 = input.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            ArrayList<Object> obj = new ArrayList<Object>();
            for (Object arg : translatable.method_11023()) {
                if (arg instanceof class_2561) {
                    class_2561 argText = (class_2561)arg;
                    obj.add(GeneralUtils.cloneTransformText(argText, transform));
                    continue;
                }
                obj.add(arg);
            }
            baseText = class_2561.method_43469((String)translatable.method_11022(), (Object[])obj.toArray());
        } else {
            baseText = input.method_27662();
        }
        for (class_2561 sibling : input.method_10855()) {
            baseText.method_10852((class_2561)GeneralUtils.cloneTransformText(sibling, transform));
        }
        baseText.method_10862(input.method_10866());
        return transform.apply(baseText);
    }

    public static class_2561 getItemText(class_1799 stack, boolean rarity) {
        if (!stack.method_7960()) {
            class_5250 mutableText = class_2561.method_43473().method_10852(stack.method_7964());
            if (stack.method_57826(class_9334.field_49631)) {
                mutableText.method_27692(class_124.field_1056);
            }
            if (rarity) {
                mutableText.method_27692(stack.method_7932().method_58413());
            }
            mutableText.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(stack))));
            return mutableText;
        }
        return class_2561.method_43473().method_10852(class_1799.field_8037.method_7964());
    }

    public static ParentNode convertToNodes(class_2561 input) {
        ArrayList<TextNode> list = new ArrayList<TextNode>();
        class_7417 class_74172 = input.method_10851();
        if (class_74172 instanceof class_8828.class_2585) {
            class_8828.class_2585 content = (class_8828.class_2585)class_74172;
            list.add(new LiteralNode(content.comp_737()));
        } else {
            class_74172 = input.method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 content = (class_2588)class_74172;
                ArrayList<Object> args = new ArrayList<Object>();
                for (Object arg : content.method_11023()) {
                    if (arg instanceof class_2561) {
                        class_2561 text = (class_2561)arg;
                        args.add(GeneralUtils.convertToNodes(text));
                        continue;
                    }
                    if (arg instanceof String) {
                        String s = (String)arg;
                        args.add(new LiteralNode(s));
                        continue;
                    }
                    args.add(arg);
                }
                list.add(TranslatedNode.ofFallback(content.method_11022(), content.method_48323(), args.toArray()));
            } else {
                class_74172 = input.method_10851();
                if (class_74172 instanceof class_2578) {
                    class_2578 content = (class_2578)class_74172;
                    list.add(new ScoreNode(content.method_10930(), content.method_10928()));
                } else {
                    class_74172 = input.method_10851();
                    if (class_74172 instanceof class_2572) {
                        class_2572 content = (class_2572)class_74172;
                        list.add(new KeybindNode(content.method_10901()));
                    } else {
                        class_74172 = input.method_10851();
                        if (class_74172 instanceof class_2579) {
                            class_2579 content = (class_2579)class_74172;
                            list.add(new SelectorNode(content.method_10932(), content.method_36339().map(GeneralUtils::convertToNodes)));
                        } else {
                            class_74172 = input.method_10851();
                            if (class_74172 instanceof class_2574) {
                                class_2574 content = (class_2574)class_74172;
                                list.add(new NbtNode(content.method_10920(), content.method_10921(), content.method_43484().map(GeneralUtils::convertToNodes), content.method_43485()));
                            }
                        }
                    }
                }
            }
        }
        for (class_2561 child : input.method_10855()) {
            list.add(GeneralUtils.convertToNodes(child));
        }
        if (input.method_10866() == class_2583.field_24360) {
            return new ParentNode(list);
        }
        class_2583 style = input.method_10866();
        ParentNode hoverValue = style.method_10969() != null && style.method_10969().method_10892() == class_2568.class_5247.field_24342 ? GeneralUtils.convertToNodes((class_2561)style.method_10969().method_10891(class_2568.class_5247.field_24342)) : null;
        LiteralNode clickValue = style.method_10970() != null ? new LiteralNode(style.method_10970().method_10844()) : null;
        LiteralNode insertion = style.method_10955() != null ? new LiteralNode(style.method_10955()) : null;
        return new StyledNode(list.toArray(new TextNode[0]), style, hoverValue, (TextNode)clickValue, (TextNode)insertion);
    }

    public static TextNode removeColors(TextNode node) {
        if (node instanceof ParentTextNode) {
            ParentTextNode parentNode = (ParentTextNode)node;
            ArrayList<TextNode> list = new ArrayList<TextNode>();
            for (TextNode child : parentNode.getChildren()) {
                list.add(GeneralUtils.removeColors(child));
            }
            if (node instanceof ColorNode || node instanceof FormattingNode) {
                return new ParentNode(list.toArray(new TextNode[0]));
            }
            if (node instanceof StyledNode) {
                StyledNode styledNode = (StyledNode)node;
                return new StyledNode(list.toArray(new TextNode[0]), styledNode.rawStyle().method_27703((class_5251)null), styledNode.hoverValue(), styledNode.clickValue(), styledNode.insertion());
            }
            return parentNode.copyWith(list.toArray(new TextNode[0]));
        }
        return node;
    }

    public record TextLengthPair(class_5250 text, int length) {
        public static final TextLengthPair EMPTY = new TextLengthPair(null, 0);
    }

    public record MutableTransformer(Function<class_2583, class_2583> textMutableTextFunction) implements Function<class_5250, class_2561>
    {
        public static final MutableTransformer CLEAR = new MutableTransformer(x -> class_2583.field_24360);

        @Override
        public class_2561 apply(class_5250 text) {
            return GeneralUtils.cloneTransformText((class_2561)text, this::transformStyle);
        }

        private class_5250 transformStyle(class_5250 mutableText) {
            return mutableText.method_10862(this.textMutableTextFunction.apply(mutableText.method_10866()));
        }
    }

    public record Pair<L, R>(L left, R right) {
    }
}

