/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.textparser;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import eu.pb4.placeholders.api.arguments.SimpleArguments;
import eu.pb4.placeholders.api.arguments.StringArgs;
import eu.pb4.placeholders.api.node.KeybindNode;
import eu.pb4.placeholders.api.node.NbtNode;
import eu.pb4.placeholders.api.node.ScoreNode;
import eu.pb4.placeholders.api.node.SelectorNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.TranslatedNode;
import eu.pb4.placeholders.api.node.parent.BoldNode;
import eu.pb4.placeholders.api.node.parent.ClickActionNode;
import eu.pb4.placeholders.api.node.parent.DynamicColorNode;
import eu.pb4.placeholders.api.node.parent.FontNode;
import eu.pb4.placeholders.api.node.parent.GradientNode;
import eu.pb4.placeholders.api.node.parent.HoverNode;
import eu.pb4.placeholders.api.node.parent.InsertNode;
import eu.pb4.placeholders.api.node.parent.ItalicNode;
import eu.pb4.placeholders.api.node.parent.ObfuscatedNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.node.parent.StrikethroughNode;
import eu.pb4.placeholders.api.node.parent.StyledNode;
import eu.pb4.placeholders.api.node.parent.TransformNode;
import eu.pb4.placeholders.api.node.parent.UnderlinedNode;
import eu.pb4.placeholders.api.parsers.tag.NodeCreator;
import eu.pb4.placeholders.api.parsers.tag.SimpleTags;
import eu.pb4.placeholders.api.parsers.tag.TagRegistry;
import eu.pb4.placeholders.api.parsers.tag.TextTag;
import eu.pb4.placeholders.impl.GeneralUtils;
import eu.pb4.placeholders.impl.StringArgOps;
import eu.pb4.placeholders.impl.textparser.TextParserImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2575;
import net.minecraft.class_2576;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_4616;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7419;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class BuiltinTags {
    public static final class_5251 DEFAULT_COLOR = class_5251.method_27718((class_124)class_124.field_1068);

    public static void register() {
        HashMap<class_124, List<String>> aliases = new HashMap<class_124, List<String>>();
        aliases.put(class_124.field_1065, List.of("orange"));
        aliases.put(class_124.field_1080, List.of("grey", "light_gray", "light_grey"));
        aliases.put(class_124.field_1076, List.of("pink"));
        aliases.put(class_124.field_1064, List.of("purple"));
        aliases.put(class_124.field_1063, List.of("dark_grey"));
        for (class_124 formatting : class_124.values()) {
            if (formatting.method_542()) continue;
            TagRegistry.registerDefault(SimpleTags.color(formatting.method_537(), aliases.containsKey(formatting) ? (Collection)aliases.get(formatting) : List.of(), formatting));
        }
        TagRegistry.registerDefault(TextTag.enclosing("bold", List.of("b"), "formatting", true, NodeCreator.bool(BoldNode::new)));
        TagRegistry.registerDefault(TextTag.enclosing("underline", List.of("underlined", "u"), "formatting", true, NodeCreator.bool(UnderlinedNode::new)));
        TagRegistry.registerDefault(TextTag.enclosing("strikethrough", List.of("st"), "formatting", true, NodeCreator.bool(StrikethroughNode::new)));
        TagRegistry.registerDefault(TextTag.enclosing("obfuscated", List.of("obf", "matrix"), "formatting", true, NodeCreator.bool(ObfuscatedNode::new)));
        TagRegistry.registerDefault(TextTag.enclosing("italic", List.of("i", "em"), "formatting", true, NodeCreator.bool(ItalicNode::new)));
        TagRegistry.registerDefault(TextTag.enclosing("color", List.of("colour", "c"), "color", true, (nodes, data, parser) -> new DynamicColorNode(nodes, parser.parseNode(data.get("value", 0, "white")))));
        TagRegistry.registerDefault(TextTag.enclosing("font", "other_formatting", false, (nodes, data, parser) -> new FontNode(nodes, class_2960.method_12829((String)data.get("value", 0, "")))));
        TagRegistry.registerDefault(TextTag.self("lang", List.of("translate"), "special", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                String part;
                String key = data.getNext("key");
                String fallback = data.get("fallback");
                ArrayList<TextNode> textList = new ArrayList<TextNode>();
                int i = 0;
                while ((part = data.getNext("" + i++)) != null) {
                    textList.add(parser.parseNode(part));
                }
                return TranslatedNode.ofFallback(key, fallback, textList.toArray(TextParserImpl.CASTER));
            }
            return TextNode.empty();
        }));
        TagRegistry.registerDefault(TextTag.self("lang_fallback", List.of("translatef", "langf", "translate_fallback"), "special", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                String part;
                String key = data.getNext("key");
                String fallback = data.getNext("fallback");
                ArrayList<TextNode> textList = new ArrayList<TextNode>();
                int i = 0;
                while ((part = data.getNext("" + i++)) != null) {
                    textList.add(parser.parseNode(part));
                }
                return TranslatedNode.ofFallback(key, fallback, textList.toArray(TextParserImpl.CASTER));
            }
            return TextNode.empty();
        }));
        TagRegistry.registerDefault(TextTag.self("keybind", List.of("key"), "special", false, data -> new KeybindNode(data.getNext("value", ""))));
        TagRegistry.registerDefault(TextTag.enclosing("click", "click_action", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                String type = data.getNext("type");
                String value = data.getNext("value", "");
                for (class_2558.class_2559 action : class_2558.class_2559.values()) {
                    if (!action.method_15434().equals(type)) continue;
                    return new ClickActionNode(nodes, action, parser.parseNode(value));
                }
            }
            return new ParentNode(nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("run_command", List.of("run_cmd"), "click_action", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                return new ClickActionNode(nodes, class_2558.class_2559.field_11750, parser.parseNode(data.get("value", 0)));
            }
            return new ParentNode(nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("suggest_command", List.of("cmd"), "click_action", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                return new ClickActionNode(nodes, class_2558.class_2559.field_11745, parser.parseNode(data.getNext("value", "")));
            }
            return new ParentNode(nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("open_url", List.of("url"), "click_action", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                return new ClickActionNode(nodes, class_2558.class_2559.field_11749, parser.parseNode(data.get("value", 0)));
            }
            return new ParentNode(nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("copy_to_clipboard", List.of("copy"), "click_action", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                return new ClickActionNode(nodes, class_2558.class_2559.field_21462, parser.parseNode(data.get("value", 0)));
            }
            return new ParentNode(nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("change_page", List.of("page"), "click_action", true, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                return new ClickActionNode(nodes, class_2558.class_2559.field_11748, parser.parseNode(data.get("value", 0)));
            }
            return new ParentNode(nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("hover", "hover_event", true, (nodes, data, parser) -> {
            try {
                String type = data.get("type");
                if (type != null || data.size() > 1) {
                    if (type == null) {
                        type = data.getNext("type", "");
                    }
                    if ((type = type.toLowerCase(Locale.ROOT)).equals("show_text") || type.equals("text")) {
                        return new HoverNode<TextNode, class_2561>(nodes, HoverNode.Action.TEXT, parser.parseNode(data.getNext("value", "")));
                    }
                    if (type.equals("show_entity") || type.equals("entity")) {
                        return new HoverNode<HoverNode.EntityNodeContent, class_2568.class_5248>(nodes, HoverNode.Action.ENTITY, new HoverNode.EntityNodeContent(class_1299.method_5898((String)data.getNext("entity", "")).orElse(class_1299.field_6093), UUID.fromString(data.getNext("uuid", class_156.field_25140.toString())), new ParentNode(parser.parseNode(data.get("name", 3, "")))));
                    }
                    if (type.equals("show_item") || type.equals("item")) {
                        String value = data.getNext("value", "");
                        try {
                            return new HoverNode<class_2568.class_5249, class_2568.class_5249>(nodes, HoverNode.Action.ITEM_STACK, new class_2568.class_5249(class_1799.method_57359((class_7225.class_7874)class_5455.field_40585, (class_2487)class_2522.method_10718((String)value))));
                        }
                        catch (Throwable e) {
                            class_1799 stack = ((class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)data.get("item", value)))).method_7854();
                            String count = data.getNext("count");
                            if (count != null) {
                                stack.method_7939(Integer.parseInt(count));
                            }
                            return new HoverNode<class_2568.class_5249, class_2568.class_5249>(nodes, HoverNode.Action.ITEM_STACK, new class_2568.class_5249(stack));
                        }
                    }
                    return new HoverNode<TextNode, class_2561>(nodes, HoverNode.Action.TEXT, parser.parseNode(data.get("value", type)));
                }
                return new HoverNode<TextNode, class_2561>(nodes, HoverNode.Action.TEXT, parser.parseNode(data.getNext("value")));
            }
            catch (Exception exception) {
                return new ParentNode(nodes);
            }
        }));
        TagRegistry.registerDefault(TextTag.enclosing("insert", List.of("insertion"), "click_action", false, (nodes, data, parser) -> new InsertNode(nodes, parser.parseNode(data.get("value", 0)))));
        TagRegistry.registerDefault(TextTag.enclosing("clear_color", List.of("uncolor", "colorless"), "special", false, (nodes, data, parser) -> GeneralUtils.removeColors(TextNode.asSingle(nodes))));
        TagRegistry.registerDefault(TextTag.enclosing("rainbow", List.of("rb"), "gradient", true, (nodes, data, parser) -> {
            String type = data.get("type", "");
            float freq = SimpleArguments.floatNumber(data.getNext("frequency", data.get("freq", data.get("f"))), 1.0f);
            float saturation = SimpleArguments.floatNumber(data.getNext("saturation", data.get("sat", data.get("s"))), 1.0f);
            float offset = SimpleArguments.floatNumber(data.getNext("offset", data.get("off", data.get("o"))), 0.0f);
            int overriddenLength = SimpleArguments.intNumber(data.getNext("length", data.get("len", data.get("l"))), -1);
            int value = SimpleArguments.intNumber(data.get("value", data.get("val", data.get("v"))), 1);
            return new GradientNode(nodes, switch (type) {
                case "oklab", "okhcl" -> {
                    if (overriddenLength < 0) {
                        yield GradientNode.GradientProvider.rainbowOkLch(saturation, value, freq, offset);
                    }
                    yield GradientNode.GradientProvider.rainbowOkLch(saturation, value, freq, offset, overriddenLength);
                }
                case "hvs" -> {
                    if (overriddenLength < 0) {
                        yield GradientNode.GradientProvider.rainbowHvs(saturation, value, freq, offset);
                    }
                    yield GradientNode.GradientProvider.rainbowHvs(saturation, value, freq, offset, overriddenLength);
                }
                default -> overriddenLength < 0 ? GradientNode.GradientProvider.rainbow(saturation, value, freq, offset) : GradientNode.GradientProvider.rainbow(saturation, value, freq, offset, overriddenLength);
            });
        }));
        TagRegistry.registerDefault(TextTag.enclosing("gradient", List.of("gr"), "gradient", true, (nodes, data, parser) -> {
            String part;
            ArrayList<class_5251> textColors = new ArrayList<class_5251>();
            int i = 0;
            String type = data.get("type", "");
            while ((part = data.getNext("" + i)) != null) {
                class_5251.method_27719((String)part).result().ifPresent(textColors::add);
            }
            return new GradientNode(nodes, switch (type) {
                case "oklab" -> GradientNode.GradientProvider.colorsOkLab(textColors);
                case "hvs" -> GradientNode.GradientProvider.colorsHvs(textColors);
                case "hard" -> GradientNode.GradientProvider.colorsHard(textColors);
                default -> GradientNode.GradientProvider.colors(textColors);
            });
        }));
        TagRegistry.registerDefault(TextTag.enclosing("hard_gradient", List.of("hgr"), "gradient", true, (nodes, data, parser) -> {
            String part;
            ArrayList<class_5251> textColors = new ArrayList<class_5251>();
            int i = 0;
            while ((part = data.getNext("" + i)) != null) {
                class_5251.method_27719((String)part).result().ifPresent(textColors::add);
            }
            if (textColors.isEmpty()) {
                return new ParentNode(nodes);
            }
            return GradientNode.colorsHard(textColors, nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("clear", "special", false, (nodes, data, parser) -> new TransformNode(nodes, BuiltinTags.getTransform(data))));
        TagRegistry.registerDefault(TextTag.enclosing("rawstyle", "special", false, (nodes, data, parser) -> {
            DataResult x = class_2583.class_2584.field_46613.decode((DynamicOps)StringArgOps.INSTANCE, (Object)Either.right((Object)data));
            if (x.error().isPresent()) {
                System.out.println(((DataResult.Error)x.error().get()).message());
                return TextNode.asSingle(nodes);
            }
            return new StyledNode(nodes, (class_2583)((Pair)x.result().get()).getFirst(), null, null, null);
        }));
        TagRegistry.registerDefault(TextTag.self("score", "special", false, (nodes, data, parser) -> new ScoreNode(data.getNext("name", ""), data.getNext("objective", ""))));
        TagRegistry.registerDefault(TextTag.self("selector", "special", false, (nodes, data, parser) -> {
            String sel = data.getNext("pattern", "@p");
            String arg = data.getNext("separator");
            return new SelectorNode(sel, arg != null ? Optional.of(TextNode.of(arg)) : Optional.empty());
        }));
        TagRegistry.registerDefault(TextTag.self("nbt", "special", false, (nodes, data, parser) -> {
            class_2575 type;
            String source = data.getNext("source", "");
            String cleanLine1 = data.getNext("path", "");
            switch (source) {
                case "block": {
                    class_2575 class_25752 = new class_2575(cleanLine1);
                    break;
                }
                case "entity": {
                    class_2575 class_25752 = new class_2576(cleanLine1);
                    break;
                }
                case "storage": {
                    class_2575 class_25752 = new class_4616(class_2960.method_12829((String)cleanLine1));
                    break;
                }
                default: {
                    class_2575 class_25752 = type = null;
                }
            }
            if (type == null) {
                return TextNode.empty();
            }
            String separ = data.getNext("separator");
            Optional<TextNode> separator = separ != null ? Optional.of(TextNode.asSingle(parser.parseNode(separ))) : Optional.empty();
            boolean shouldInterpret = SimpleArguments.bool(data.getNext("interpret"), false);
            return new NbtNode(cleanLine1, shouldInterpret, separator, (class_7419)type);
        }));
    }

    private static Function<class_5250, class_2561> getTransform(StringArgs val) {
        if (val.isEmpty()) {
            return GeneralUtils.MutableTransformer.CLEAR;
        }
        Function<class_2583, class_2583> func = x -> x;
        Iterator<String> iterator = val.ordered().iterator();
        while (iterator.hasNext()) {
            String arg;
            func = func.andThen(switch (arg = iterator.next()) {
                case "hover" -> x -> x.method_10949(null);
                case "click" -> x -> x.method_10958(null);
                case "color" -> x -> x.method_27703((class_5251)null);
                case "insertion" -> x -> x.method_10975(null);
                case "font" -> x -> x.method_27704(null);
                case "bold" -> x -> x.method_10982(null);
                case "italic" -> x -> x.method_10978(null);
                case "underline" -> x -> x.method_30938(null);
                case "strikethrough" -> x -> x.method_36140(null);
                case "all" -> x -> class_2583.field_24360;
                default -> x -> x;
            });
        }
        return new GeneralUtils.MutableTransformer(func);
    }

    private static boolean isntFalse(String arg) {
        return SimpleArguments.bool(arg, arg.isEmpty());
    }
}

