/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.config;

import com.google.common.collect.HashMultimap;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.Owo;
import io.wispforest.owo.config.ConfigWrapper;
import io.wispforest.owo.config.Option;
import io.wispforest.owo.mixin.ServerCommonNetworkHandlerAccessor;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ConfigSynchronizer {
    public static final class_2960 CONFIG_SYNC_CHANNEL = class_2960.method_60655((String)"owo", (String)"config_sync");
    private static final Map<class_2535, Map<String, Map<Option.Key, Object>>> CLIENT_OPTION_STORAGE = new WeakHashMap<class_2535, Map<String, Map<Option.Key, Object>>>();
    private static final Map<String, ConfigWrapper<?>> KNOWN_CONFIGS = new HashMap();
    private static final class_5250 PREFIX = TextOps.concat(Owo.PREFIX, class_2561.method_30163((String)"\u00a7cunrecoverable config mismatch\n\n"));

    static void register(ConfigWrapper<?> config) {
        KNOWN_CONFIGS.put(config.name(), config);
    }

    @Nullable
    public static Map<Option.Key, ?> getClientOptions(class_3222 player, String configName) {
        Map<String, Map<Option.Key, Object>> storage = CLIENT_OPTION_STORAGE.get(((ServerCommonNetworkHandlerAccessor)player.field_13987).owo$getConnection());
        if (storage == null) {
            return null;
        }
        return storage.get(configName);
    }

    @Nullable
    public static Map<Option.Key, ?> getClientOptions(class_3222 player, ConfigWrapper<?> config) {
        return ConfigSynchronizer.getClientOptions(player, config.name());
    }

    private static ConfigSyncPacket toPacket(Option.SyncMode targetMode) {
        HashMap<String, ConfigEntry> configs = new HashMap<String, ConfigEntry>();
        KNOWN_CONFIGS.forEach((configName, config) -> {
            ConfigEntry entry = new ConfigEntry(new HashMap<String, class_2540>());
            config.allOptions().forEach((key, option) -> {
                if (option.syncMode().ordinal() < targetMode.ordinal()) {
                    return;
                }
                class_2540 optionBuf = PacketByteBufs.create();
                option.write(optionBuf);
                entry.options().put(key.asString(), optionBuf);
            });
            configs.put((String)configName, entry);
        });
        return new ConfigSyncPacket(configs);
    }

    private static void read(ConfigSyncPacket packet, BiConsumer<Option<?>, class_2540> optionConsumer) {
        for (Map.Entry<String, ConfigEntry> configEntry : packet.configs().entrySet()) {
            String configName = configEntry.getKey();
            ConfigWrapper<?> config = KNOWN_CONFIGS.get(configName);
            if (config == null) {
                Owo.LOGGER.error("Received overrides for unknown config '{}', skipping", (Object)configName);
                continue;
            }
            for (Map.Entry<String, class_2540> optionEntry : configEntry.getValue().options().entrySet()) {
                Option.Key optionKey = new Option.Key(optionEntry.getKey());
                Option option = config.optionForKey(optionKey);
                if (option == null) {
                    Owo.LOGGER.error("Received override for unknown option '{}' in config '{}', skipping", (Object)optionKey, (Object)configName);
                    continue;
                }
                optionConsumer.accept(option, optionEntry.getValue());
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void applyClient(ConfigSyncPacket payload, ClientPlayNetworking.Context context) {
        Owo.LOGGER.info("Applying server overrides");
        HashMap<Option, Object> mismatchedOptions = new HashMap<Option, Object>();
        if (!context.client().method_1496() || !context.client().method_1576().method_3724()) {
            ConfigSynchronizer.read(payload, (option, packetByteBuf) -> {
                Object mismatchedValue = option.read((class_2540)packetByteBuf);
                if (mismatchedValue != null) {
                    mismatchedOptions.put((Option)option, mismatchedValue);
                }
            });
            if (!mismatchedOptions.isEmpty()) {
                Owo.LOGGER.error("Aborting connection, non-syncable config values were mismatched");
                mismatchedOptions.forEach((option, serverValue) -> Owo.LOGGER.error("- Option {} in config '{}' has value '{}' but server requires '{}'", (Object)option.key().asString(), (Object)option.configName(), option.value(), serverValue));
                class_5250 errorMessage = class_2561.method_43473();
                HashMultimap optionsByConfig = HashMultimap.create();
                mismatchedOptions.forEach((option, serverValue) -> optionsByConfig.put((Object)option.configName(), (Object)new class_3545(option, serverValue)));
                for (String configName : optionsByConfig.keys()) {
                    errorMessage.method_10852((class_2561)TextOps.withFormatting("in config ", class_124.field_1080)).method_27693(configName).method_27693("\n");
                    for (class_3545 option2 : optionsByConfig.get((Object)configName)) {
                        errorMessage.method_10852((class_2561)class_2561.method_43471((String)((Option)option2.method_15442()).translationKey()).method_27692(class_124.field_1054)).method_27693(" -> ");
                        errorMessage.method_27693(((Option)option2.method_15442()).value().toString()).method_10852((class_2561)TextOps.withFormatting(" (client)", class_124.field_1080));
                        errorMessage.method_10852((class_2561)TextOps.withFormatting(" / ", class_124.field_1063));
                        errorMessage.method_27693(option2.method_15441().toString()).method_10852((class_2561)TextOps.withFormatting(" (server)", class_124.field_1080)).method_27693("\n");
                    }
                    errorMessage.method_27693("\n");
                }
                errorMessage.method_10852((class_2561)TextOps.withFormatting("these options could not be synchronized because\n", class_124.field_1080));
                errorMessage.method_10852((class_2561)TextOps.withFormatting("they require your client to be restarted\n", class_124.field_1080));
                errorMessage.method_10852((class_2561)TextOps.withFormatting("change them manually and restart if you want to join this server", class_124.field_1080));
                context.player().field_3944.method_48296().method_10747((class_2561)TextOps.concat((class_2561)PREFIX, (class_2561)errorMessage));
                return;
            }
        }
        Owo.LOGGER.info("Responding with client values");
        context.responseSender().sendPacket((class_8710)ConfigSynchronizer.toPacket(Option.SyncMode.INFORM_SERVER));
    }

    private static void applyServer(ConfigSyncPacket payload, ServerPlayNetworking.Context context) {
        Owo.LOGGER.info("Receiving client config");
        class_2535 connection = ((ServerCommonNetworkHandlerAccessor)context.player().field_13987).owo$getConnection();
        ConfigSynchronizer.read(payload, (option, optionBuf) -> {
            Map config = CLIENT_OPTION_STORAGE.computeIfAbsent(connection, $ -> new HashMap()).computeIfAbsent(option.configName(), s -> new HashMap());
            config.put(option.key(), optionBuf.read(option.endec()));
        });
    }

    static {
        class_9139 packetCodec = CodecUtils.toPacketCodec(ConfigSyncPacket.ENDEC);
        PayloadTypeRegistry.playS2C().register(ConfigSyncPacket.ID, packetCodec);
        PayloadTypeRegistry.playC2S().register(ConfigSyncPacket.ID, packetCodec);
        class_2960 earlyPhase = class_2960.method_60655((String)"owo", (String)"early");
        ServerPlayConnectionEvents.JOIN.addPhaseOrdering(earlyPhase, Event.DEFAULT_PHASE);
        ServerPlayConnectionEvents.JOIN.register(earlyPhase, (handler, sender, server) -> {
            Owo.LOGGER.info("Sending server config values to client");
            sender.sendPacket((class_8710)ConfigSynchronizer.toPacket(Option.SyncMode.OVERRIDE_CLIENT));
        });
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver(ConfigSyncPacket.ID, ConfigSynchronizer::applyClient);
            ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> KNOWN_CONFIGS.forEach((name, config) -> config.forEachOption(Option::reattach)));
        }
        ServerPlayNetworking.registerGlobalReceiver(ConfigSyncPacket.ID, ConfigSynchronizer::applyServer);
    }

    private record ConfigSyncPacket(Map<String, ConfigEntry> configs) implements class_8710
    {
        public static final class_8710.class_9154<ConfigSyncPacket> ID = new class_8710.class_9154(CONFIG_SYNC_CHANNEL);
        public static final Endec<ConfigSyncPacket> ENDEC = StructEndecBuilder.of((StructField)ConfigEntry.ENDEC.mapOf().fieldOf("configs", ConfigSyncPacket::configs), ConfigSyncPacket::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    private record ConfigEntry(Map<String, class_2540> options) {
        public static final Endec<ConfigEntry> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.PACKET_BYTE_BUF.mapOf().fieldOf("options", ConfigEntry::options), ConfigEntry::new);
    }
}

