/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.container;

import io.wispforest.owo.ui.container.WrappingParentComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class DraggableContainer<C extends Component>
extends WrappingParentComponent<C> {
    protected int foreheadSize = 10;
    protected int baseX = 0;
    protected int baseY = 0;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;

    protected DraggableContainer(Sizing horizontalSizing, Sizing verticalSizing, C child) {
        super(horizontalSizing, verticalSizing, child);
        this.padding(Insets.none());
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        this.drawChildren(context, mouseX, mouseY, partialTicks, delta, this.childView);
    }

    @Override
    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.MOUSE_CLICK;
    }

    @Override
    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        this.xOffset += deltaX;
        this.yOffset += deltaY;
        super.updateX((int)((long)this.baseX + Math.round(this.xOffset)));
        super.updateY((int)((long)this.baseY + Math.round(this.yOffset)));
        return super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
    }

    @Override
    @Nullable
    public Component childAt(int x, int y) {
        if (this.isInBoundingBox(x, y) && y - this.y < this.foreheadSize) {
            return this;
        }
        return super.childAt(x, y);
    }

    @Override
    public void updateX(int x) {
        this.baseX = x;
        super.updateX((int)((long)x + Math.round(this.xOffset)));
    }

    @Override
    public void updateY(int y) {
        this.baseY = y;
        super.updateY((int)((long)y + Math.round(this.yOffset)));
    }

    @Override
    public int baseX() {
        return this.baseX;
    }

    @Override
    public int baseY() {
        return this.baseY;
    }

    @Override
    public ParentComponent padding(Insets padding) {
        return super.padding(Insets.of(padding.top() + this.foreheadSize, padding.bottom(), padding.left(), padding.right()));
    }

    public DraggableContainer<C> foreheadSize(int foreheadSize) {
        int prevForeheadSize = this.foreheadSize;
        this.foreheadSize = foreheadSize;
        Insets padding = (Insets)this.padding.get();
        this.padding(Insets.of(padding.top() - prevForeheadSize, padding.bottom(), padding.left(), padding.right()));
        return this;
    }

    public int foreheadSize() {
        return this.foreheadSize;
    }

    @Deprecated(forRemoval=true)
    public DraggableContainer<C> alwaysOnTop(boolean alwaysOnTop) {
        this.zIndex(alwaysOnTop ? 500 : 0);
        return this;
    }

    public boolean alwaysOnTop() {
        return false;
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "forehead-size", UIParsing::parseUnsignedInt, this::foreheadSize);
        UIParsing.apply(children, "always-on-top", UIParsing::parseBool, this::alwaysOnTop);
    }
}

