/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_3532;
import org.w3c.dom.Element;

public class Sizing
implements Animatable<Sizing> {
    private static final Sizing CONTENT_SIZING = new Sizing(0, Method.CONTENT);
    public final Method method;
    public final int value;

    private Sizing(int value, Method method) {
        this.method = method;
        this.value = value;
    }

    public int inflate(int space, Function<Sizing, Integer> contentSizeFunction) {
        return switch (this.method.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.value;
            case 2, 3 -> Math.round((float)this.value / 100.0f * (float)space);
            case 1 -> contentSizeFunction.apply(this) + this.value * 2;
        };
    }

    public static Sizing fixed(int value) {
        return new Sizing(value, Method.FIXED);
    }

    public static Sizing content() {
        return CONTENT_SIZING;
    }

    public static Sizing content(int padding) {
        return new Sizing(padding, Method.CONTENT);
    }

    public static Sizing fill() {
        return Sizing.fill(100);
    }

    public static Sizing fill(int percent) {
        return new Sizing(percent, Method.FILL);
    }

    public static Sizing expand() {
        return Sizing.expand(100);
    }

    public static Sizing expand(int percent) {
        return new Sizing(percent, Method.EXPAND);
    }

    public boolean isContent() {
        return this.method == Method.CONTENT;
    }

    public boolean isExpand() {
        return this.method == Method.EXPAND;
    }

    public float contentFactor() {
        return this.isContent() ? 1.0f : 0.0f;
    }

    @Override
    public Sizing interpolate(Sizing next, float delta) {
        if (next.method != this.method) {
            return new MergedSizing(this, next, delta);
        }
        return new Sizing(class_3532.method_48781((float)delta, (int)this.value, (int)next.value), this.method);
    }

    public static Sizing parse(Element sizingElement) {
        String methodString = sizingElement.getAttribute("method");
        if (methodString.isBlank()) {
            throw new UIModelParsingException("Missing 'method' attribute on sizing declaration. Must be one of: fixed, content, fill");
        }
        Method method = Method.valueOf(methodString.toUpperCase(Locale.ROOT));
        String value = sizingElement.getTextContent().strip();
        if (method == Method.CONTENT) {
            if (!value.matches("(-?\\d+)?")) {
                throw new UIModelParsingException("Invalid value in sizing declaration");
            }
            return new Sizing(value.isEmpty() ? 0 : Integer.parseInt(value), method);
        }
        if (!value.matches("-?\\d+")) {
            throw new UIModelParsingException("Invalid value in sizing declaration");
        }
        return new Sizing(Integer.parseInt(value), method);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sizing sizing = (Sizing)o;
        return this.value == sizing.value && this.method == sizing.method;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.value});
    }

    public static enum Method {
        FIXED,
        CONTENT,
        FILL,
        EXPAND;

    }

    private static final class MergedSizing
    extends Sizing {
        private final Sizing first;
        private final Sizing second;
        private final float delta;

        private MergedSizing(Sizing first, Sizing second, float delta) {
            super(first.value, first.method);
            this.first = first;
            this.second = second;
            this.delta = delta;
        }

        @Override
        public int inflate(int space, Function<Sizing, Integer> contentSizeFunction) {
            return class_3532.method_48781((float)this.delta, (int)this.first.inflate(space, contentSizeFunction), (int)this.second.inflate(space, contentSizeFunction));
        }

        @Override
        public Sizing interpolate(Sizing next, float delta) {
            return this.first.interpolate(next, delta);
        }

        @Override
        public boolean isContent() {
            return this.first.isContent() || this.second.isContent();
        }

        @Override
        public float contentFactor() {
            if (this.first.isContent() && this.second.isContent()) {
                return super.contentFactor();
            }
            if (this.first.isContent()) {
                return 1.0f - this.delta;
            }
            if (this.second.isContent()) {
                return this.delta;
            }
            return 0.0f;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MergedSizing that = (MergedSizing)o;
            return Float.compare(this.delta, that.delta) == 0 && Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.first, this.second, Float.valueOf(this.delta));
        }
    }

    public static class Random {
        private static final java.util.Random SIZING_RANDOM = new java.util.Random();

        public static Sizing fill(int min, int max) {
            return Sizing.fill(SIZING_RANDOM.nextInt(min, max));
        }

        public static Sizing fill(int max) {
            return Sizing.fill(SIZING_RANDOM.nextInt(0, max));
        }

        public static Sizing fill() {
            return Sizing.fill(SIZING_RANDOM.nextInt(0, 100));
        }

        public static Sizing expand(int min, int max) {
            return Sizing.expand(SIZING_RANDOM.nextInt(min, max));
        }

        public static Sizing expand(int max) {
            return Sizing.expand(SIZING_RANDOM.nextInt(0, max));
        }

        public static Sizing expand() {
            return Sizing.expand(SIZING_RANDOM.nextInt(0, 100));
        }

        public static Sizing fixed(int min, int max) {
            return Sizing.fixed(SIZING_RANDOM.nextInt(min, max));
        }

        public static Sizing fixed(int max) {
            return Sizing.fixed(SIZING_RANDOM.nextInt(0, max));
        }

        public static Sizing fixed() {
            return Sizing.fixed(SIZING_RANDOM.nextInt(0, 100));
        }

        public static Sizing content(int min, int max) {
            return Sizing.content(SIZING_RANDOM.nextInt(min, max));
        }

        public static Sizing content(int max) {
            return Sizing.content(SIZING_RANDOM.nextInt(0, max));
        }

        public static Sizing content() {
            return Sizing.content(SIZING_RANDOM.nextInt(0, 100));
        }

        public static Sizing random(int min, int max) {
            return switch (SIZING_RANDOM.nextInt(0, 4)) {
                case 0 -> Random.fill(min, max);
                case 1 -> Random.expand(min, max);
                case 2 -> Random.fixed(min, max);
                case 3 -> Random.content(min, max);
                default -> throw new IllegalStateException("Unexpected value: " + SIZING_RANDOM.nextInt(0, 4));
            };
        }

        public static Sizing random(int max) {
            return Random.random(0, max);
        }

        public static Sizing random() {
            return Random.random(0, 100);
        }

        public static Sizing noContent(int min, int max) {
            return switch (SIZING_RANDOM.nextInt(0, 3)) {
                case 0 -> Random.fill(min, max);
                case 1 -> Random.expand(min, max);
                case 2 -> Random.fixed(min, max);
                default -> throw new IllegalStateException("Unexpected value: " + SIZING_RANDOM.nextInt(0, 3));
            };
        }

        public static Sizing noContent(int max) {
            return Random.noContent(0, max);
        }

        public static Sizing noContent() {
            return Random.noContent(0, 100);
        }
    }
}

