/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.api;

import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.api.FTBChunksProperties;
import dev.ftb.mods.ftbchunks.api.FTBChunksTags;
import dev.ftb.mods.ftbchunks.api.ProtectionPolicy;
import java.util.stream.StreamSupport;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_4081;
import net.minecraft.class_4174;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface Protection {
    public static final Protection EDIT_BLOCK = (player, pos, hand, chunk, entity) -> {
        class_2680 blockState = player.method_37908().method_8320(pos);
        if (blockState.method_26164(FTBChunksTags.Blocks.EDIT_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_EDIT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection INTERACT_BLOCK = (player, pos, hand, chunk, entity) -> {
        class_2680 blockState = player.method_37908().method_8320(pos);
        if (blockState.method_26164(FTBChunksTags.Blocks.INTERACT_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_INTERACT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection RIGHT_CLICK_ITEM = (player, pos, hand, chunk, entity) -> {
        class_1799 stack = player.method_5998(hand);
        if (Protection.isFood(stack) || Protection.isBeneficialPotion(stack) || stack.method_31573(FTBChunksTags.Items.RIGHT_CLICK_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_INTERACT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && stack.method_31573(FTBChunksTags.Items.RIGHT_CLICK_BLACKLIST_TAG)) {
            return ProtectionPolicy.DENY;
        }
        return ProtectionPolicy.ALLOW;
    };
    public static final Protection EDIT_FLUID = (player, pos, hand, chunk, entity) -> {
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_EDIT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection INTERACT_ENTITY = (player, pos, hand, chunk, entity) -> {
        if (entity != null && entity.method_5864().method_20210(FTBChunksTags.Entities.ENTITY_INTERACT_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.ENTITY_INTERACT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection ATTACK_NONLIVING_ENTITY = (player, pos, hand, chunk, entity) -> {
        if (entity != null && entity.method_5864().method_20210(FTBChunksTags.Entities.NONLIVING_ENTITY_ATTACK_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.NONLIVING_ENTITY_ATTACK_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };
    public static final Protection EDIT_AND_INTERACT_BLOCK = (player, pos, hand, chunk, entity) -> {
        class_2680 blockState = player.method_37908().method_8320(pos);
        if (blockState.method_26164(FTBChunksTags.Blocks.INTERACT_WHITELIST_TAG)) {
            return ProtectionPolicy.ALLOW;
        }
        if (chunk != null && chunk.getTeamData().canPlayerUse(player, FTBChunksProperties.BLOCK_EDIT_AND_INTERACT_MODE)) {
            return ProtectionPolicy.ALLOW;
        }
        return ProtectionPolicy.CHECK;
    };

    public ProtectionPolicy getProtectionPolicy(class_3222 var1, class_2338 var2, class_1268 var3, @Nullable ClaimedChunk var4, @Nullable class_1297 var5);

    public static boolean isFood(class_1799 stack) {
        return stack.method_57826(class_9334.field_50075) && ((class_4174)stack.method_57824(class_9334.field_50075)).comp_2491() > 0;
    }

    public static boolean isBeneficialPotion(class_1799 stack) {
        if (stack.method_57826(class_9334.field_49651)) {
            return StreamSupport.stream(((class_1844)stack.method_57824(class_9334.field_49651)).method_57397().spliterator(), false).noneMatch(effect -> ((class_1291)effect.method_5579().comp_349()).method_18792() == class_4081.field_18272);
        }
        return false;
    }
}

