/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.client.icon.MapType;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.gui.ChunkScreen;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.gui.PointerIcon;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.RenderMapImageTask;
import dev.ftb.mods.ftbchunks.net.RequestChunkChangePacket;
import dev.ftb.mods.ftbchunks.net.RequestMapDataPacket;
import dev.ftb.mods.ftbchunks.net.UpdateForceLoadExpiryPacket;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class ChunkScreenPanel
extends Panel {
    private static final ImageIcon FORCE_LOAD_ICON = new ImageIcon(FTBChunksAPI.rl("textures/force_loaded.png"));
    private static final ImageIcon CHECKERED_ICON = new ImageIcon(FTBChunksAPI.rl("textures/checkered.png"));
    private final List<ChunkButton> chunkButtons = new ArrayList<ChunkButton>();
    private final Set<XZ> selectedChunks = new HashSet<XZ>();
    private final List<ChunkButtonPos> chunkedPosList = new ArrayList<ChunkButtonPos>();
    public boolean isAdminEnabled;
    private ChunkUpdateInfo updateInfo;
    public int tileSizeX = 16;
    public int tileSizeY = 16;
    private final ChunkScreen chunkScreen;

    public ChunkScreenPanel(ChunkScreen panel) {
        super((Panel)panel);
        this.chunkScreen = panel;
        RenderMapImageTask.setAlwaysRenderChunksOnMap(true);
        this.isAdminEnabled = class_310.method_1551().method_47392();
        MapManager.getInstance().ifPresent(m -> m.updateAllRegions(false));
        this.alignWidgets();
    }

    public static void notifyChunkUpdates(int totalChunks, int changedChunks, EnumMap<ClaimResult.StandardProblem, Integer> problems) {
        ScreenWrapper sw;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof ScreenWrapper && (class_4372 = (sw = (ScreenWrapper)class_4372).getGui()) instanceof ChunkScreen) {
            ChunkScreen cs = (ChunkScreen)class_4372;
            cs.getChunkScreen().updateInfo = new ChunkUpdateInfo(totalChunks, changedChunks, problems, class_310.method_1551().field_1687.method_8510());
        }
    }

    public void onClosed() {
        RenderMapImageTask.setAlwaysRenderChunksOnMap(false);
        MapManager.getInstance().ifPresent(m -> m.updateAllRegions(false));
        super.onClosed();
    }

    public void addWidgets() {
        class_746 player = class_310.method_1551().field_1724;
        class_1923 chunkPos = player.method_31476();
        int startX = chunkPos.field_9181 - 7;
        int startZ = chunkPos.field_9180 - 7;
        this.chunkButtons.clear();
        for (int z = 0; z < 15; ++z) {
            for (int x = 0; x < 15; ++x) {
                ChunkButton button = new ChunkButton(this, XZ.of((int)(startX + x), (int)(startZ + z)));
                this.chunkButtons.add(button);
                this.chunkedPosList.add(new ChunkButtonPos(button, x, z));
            }
        }
        this.addAll(this.chunkButtons);
        NetworkManager.sendToServer((class_8710)new RequestMapDataPacket(chunkPos.field_9181 - 7, chunkPos.field_9180 - 7, chunkPos.field_9181 + 7, chunkPos.field_9180 + 7));
    }

    public void alignWidgets() {
        int maxWidth = this.getWidth() / 15 * 15;
        int maxHeight = this.getHeight() / 15 * 15;
        int xPos = (this.getWidth() - maxWidth) / 2;
        int yPos = (this.getHeight() - maxHeight) / 2;
        this.tileSizeX = maxWidth / 15;
        this.tileSizeY = maxHeight / 15;
        for (ChunkButtonPos chunkedPos : this.chunkedPosList) {
            chunkedPos.button.setPos(xPos + this.tileSizeX * chunkedPos.x, yPos + this.tileSizeY * chunkedPos.y);
            chunkedPos.button.setSize(this.tileSizeX, this.tileSizeY);
        }
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        if (!this.selectedChunks.isEmpty()) {
            Optional<UUID> teamId = Optional.ofNullable(this.chunkScreen.getOpenedAs()).map(Team::getTeamId);
            NetworkManager.sendToServer((class_8710)new RequestChunkChangePacket(RequestChunkChangePacket.ChunkChangeOp.create(button.isLeft(), ChunkScreenPanel.isShiftKeyDown()), this.selectedChunks, this.canChangeAsAdmin(), teamId));
            this.selectedChunks.clear();
            this.playClickSound();
        }
    }

    public void removeAllClaims() {
        Optional<UUID> teamId = Optional.ofNullable(this.chunkScreen.getOpenedAs()).map(Team::getTeamId);
        Set<XZ> allChunks = this.chunkedPosList.stream().map(ChunkButtonPos::button).map(ChunkButton::getChunkPos).collect(Collectors.toSet());
        NetworkManager.sendToServer((class_8710)new RequestChunkChangePacket(RequestChunkChangePacket.ChunkChangeOp.UNCLAIM, allChunks, this.canChangeAsAdmin(), teamId));
    }

    public boolean keyPressed(Key key) {
        if (FTBChunksWorldConfig.playerHasMapStage((class_1657)class_310.method_1551().field_1724) && (key.is(77) || key.is(67))) {
            LargeMapScreen.openMap();
            return true;
        }
        return super.keyPressed(key);
    }

    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        class_746 player = class_310.method_1551().field_1724;
        int maxWidth = this.getWidth() / 15 * 15;
        int maxHeight = this.getHeight() / 15 * 15;
        int xPos = (this.getWidth() - maxWidth) / 2;
        int yPos = (this.getHeight() - maxHeight) / 2;
        int sx = this.getX() + xPos;
        int sy = this.getY() + yPos;
        RenderSystem.setShaderTexture((int)0, (int)FTBChunksClient.INSTANCE.getMinimapTextureId());
        GuiHelper.drawTexturedRect((class_332)graphics, (int)sx, (int)sy, (int)maxWidth, (int)maxHeight, (Color4I)Color4I.WHITE, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        if (!class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)258)) {
            for (int gy = 1; gy < 15; ++gy) {
                graphics.method_25292(sx, sx + maxWidth - 1, sy + gy * this.tileSizeY, 0x64464646);
            }
            for (int gx = 1; gx < 15; ++gx) {
                graphics.method_25301(sx + gx * this.tileSizeX, sy - 1, sy + maxHeight, 0x64464646);
            }
        }
        double hx = (double)(sx + this.tileSizeX * 7) + MathUtils.mod((double)player.method_23317(), (double)16.0);
        double hy = (double)(sy + this.tileSizeY * 7) + MathUtils.mod((double)player.method_23321(), (double)16.0);
        new PointerIcon().draw(MapType.LARGE_MAP, graphics, (int)(hx - 4.0), (int)(hy - 4.0), 8, 8, false, 255);
        FaceIcon.getFace((GameProfile)player.method_7334()).draw(graphics, (int)(hx - 4.0), (int)(hy - 4.0), 8, 8);
        if (this.updateInfo != null && this.updateInfo.shouldDisplay()) {
            theme.drawString(graphics, (Object)this.updateInfo.summary(), sx + 2, sy + 2, 2);
            int line = 1;
            for (Map.Entry<ClaimResult.StandardProblem, Integer> entry : this.updateInfo.problems.entrySet()) {
                ClaimResult.StandardProblem problem = entry.getKey();
                int count = entry.getValue();
                theme.drawString(graphics, (Object)problem.getMessage().method_27693(": " + count), sx + 2, sy + 5 + theme.getFontHeight() * line++, 2);
            }
        }
    }

    private boolean canChangeAsAdmin() {
        return class_310.method_1551().field_1724.method_5687(2) && this.chunkScreen.getOpenedAs() == null && this.isAdminEnabled;
    }

    public record ChunkUpdateInfo(int totalChunks, int changedChunks, EnumMap<ClaimResult.StandardProblem, Integer> problems, long timestamp) {
        public boolean shouldDisplay() {
            long timeout = 60L + 20L * (long)this.problems.size();
            return class_310.method_1551().field_1687.method_8510() - this.timestamp < timeout;
        }

        public class_2561 summary() {
            class_124 color = this.changedChunks == 0 ? class_124.field_1061 : (this.changedChunks < this.totalChunks ? class_124.field_1054 : class_124.field_1060);
            return class_2561.method_43469((String)"ftbchunks.claim_result", (Object[])new Object[]{this.changedChunks, this.totalChunks}).method_27695(new class_124[]{class_124.field_1073, color});
        }
    }

    private class ChunkButton
    extends Button {
        private final XZ chunkPos;
        private final MapChunk chunk;
        private long lastAdjust;

        public ChunkButton(Panel panel, XZ xz) {
            super(panel, (class_2561)class_2561.method_43473(), (Icon)Color4I.empty());
            this.lastAdjust = 0L;
            this.setSize(16, 16);
            this.chunkPos = xz;
            this.chunk = ChunkScreenPanel.this.chunkScreen.getDimension().getRegion(XZ.regionFromChunk((int)this.chunkPos.x(), (int)this.chunkPos.z())).getDataBlocking().getChunk(this.chunkPos);
        }

        public void onClicked(MouseButton mouseButton) {
            ChunkScreenPanel.this.selectedChunks.add(this.chunkPos);
        }

        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            if (this.chunk.getForceLoadedDate().isPresent() && !class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)258)) {
                this.chunk.getTeam().ifPresent(team -> {
                    Color4I teamColor = (Color4I)team.getProperties().get((TeamProperty)TeamProperties.COLOR);
                    float[] hsb = Color4I.RGBtoHSB((int)teamColor.redi(), (int)teamColor.greeni(), (int)teamColor.bluei(), null);
                    hsb[0] = (hsb[0] + 0.5f) % 1.0f;
                    FORCE_LOAD_ICON.withColor(Color4I.hsb((float)hsb[0], (float)hsb[1], (float)hsb[2])).draw(graphics, x, y, w, h);
                });
            }
            if (this.isMouseOver() || ChunkScreenPanel.this.selectedChunks.contains(this.chunkPos)) {
                Color4I.WHITE.withAlpha(100).draw(graphics, x, y, w, h);
                CHECKERED_ICON.withColor(Color4I.GRAY.withAlpha(150)).draw(graphics, x, y, w, h);
            }
        }

        public boolean mouseDragged(int button, double dragX, double dragY) {
            if (this.isMouseOver() && (ChunkButton.isMouseButtonDown((MouseButton)MouseButton.LEFT) || ChunkButton.isMouseButtonDown((MouseButton)MouseButton.RIGHT))) {
                ChunkScreenPanel.this.selectedChunks.add(this.chunkPos);
            }
            return super.mouseDragged(button, dragX, dragY);
        }

        public void addMouseOverText(TooltipList list) {
            if (this.chunk == null) {
                return;
            }
            this.chunk.getTeam().ifPresent(team -> {
                list.add((class_2561)team.getName().method_27661().method_27692(class_124.field_1068));
                Date date = new Date();
                this.chunk.getClaimedDate().ifPresent(claimedDate -> {
                    if (class_437.method_25443()) {
                        list.add((class_2561)class_2561.method_43470((String)claimedDate.toLocaleString()).method_27692(class_124.field_1080));
                    } else {
                        list.add((class_2561)class_2561.method_43470((String)(TimeUtils.prettyTimeString((long)((date.getTime() - claimedDate.getTime()) / 1000L)) + " ago")).method_27692(class_124.field_1080));
                    }
                });
                this.chunk.getForceLoadedDate().ifPresent(forceLoadedDate -> {
                    list.add((class_2561)class_2561.method_43471((String)"ftbchunks.gui.force_loaded").method_27692(class_124.field_1054));
                    String loadStr = class_437.method_25443() ? "  " + forceLoadedDate.toLocaleString() : "  " + TimeUtils.prettyTimeString((long)((date.getTime() - forceLoadedDate.getTime()) / 1000L)) + " ago";
                    list.add((class_2561)class_2561.method_43470((String)loadStr).method_27692(class_124.field_1080));
                    this.chunk.getForceLoadExpiryDate().ifPresent(expiryDate -> {
                        list.add((class_2561)class_2561.method_43471((String)"ftbchunks.gui.force_load_expires").method_27692(class_124.field_1065));
                        String expireStr = class_437.method_25443() ? "  " + expiryDate.toLocaleString() : "  " + TimeUtils.prettyTimeString((long)((expiryDate.getTime() - date.getTime()) / 1000L)) + " from now";
                        list.add((class_2561)class_2561.method_43470((String)expireStr).method_27692(class_124.field_1080));
                    });
                    if (!class_437.method_25443()) {
                        list.add((class_2561)class_2561.method_43471((String)"ftbchunks.gui.hold_alt_for_dates").method_27692(class_124.field_1063));
                    }
                    if (team.getRankForPlayer(class_310.method_1551().field_1724.method_5667()).isMemberOrBetter()) {
                        list.add((class_2561)class_2561.method_43471((String)"ftbchunks.gui.mouse_wheel_expiry").method_27692(class_124.field_1063));
                    }
                });
            });
        }

        public boolean mouseScrolled(double scroll) {
            return this.chunk.getForceLoadedDate().map(forceLoadedDate -> {
                class_746 player = class_310.method_1551().field_1724;
                boolean teamMember = this.chunk.isTeamMember((class_1657)player);
                if (this.isMouseOver && (ChunkScreenPanel.this.canChangeAsAdmin() || teamMember)) {
                    int dir = (int)Math.signum(scroll);
                    long now = System.currentTimeMillis();
                    Date expiry = this.chunk.getForceLoadExpiryDate().orElse(new Date(now));
                    long offset = ChunkButton.calcOffset(expiry, now, dir);
                    this.chunk.updateForceLoadExpiryDate(now, offset * 1000L);
                    this.lastAdjust = now;
                    return true;
                }
                return super.mouseScrolled(scroll);
            }).orElse(super.mouseScrolled(scroll));
        }

        private static long calcOffset(Date expiry, long now, int dir) {
            long offset = (expiry.getTime() - now) / 1000L;
            if (dir == 1) {
                offset = offset < 86400L ? (offset += 3600L) : (offset < 604800L ? (offset += 86400L) : (offset += 604800L));
            } else if (dir == -1) {
                offset = offset <= 86400L ? Math.max(0L, offset - 3600L) : (offset <= 604800L ? Math.max(86400L, offset - 86400L) : Math.max(604800L, offset - 604800L));
            }
            return offset;
        }

        public void tick() {
            super.tick();
            if (this.lastAdjust > 0L && System.currentTimeMillis() - this.lastAdjust > 1000L) {
                NetworkManager.sendToServer((class_8710)new UpdateForceLoadExpiryPacket(this.chunkPos.dim((class_1937)class_310.method_1551().field_1687), this.chunk.getForceLoadExpiryDate().orElse(null)));
                this.lastAdjust = 0L;
            }
        }

        public XZ getChunkPos() {
            return this.chunkPos;
        }
    }

    private record ChunkButtonPos(ChunkButton button, int x, int y) {
    }
}

