/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.gui.WaypointShareMenu;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.WaypointImpl;
import dev.ftb.mods.ftbchunks.net.TeleportFromMapPacket;
import dev.ftb.mods.ftblibrary.config.ColorConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ColorSelectorPanel;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.ToggleableButton;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractThreePanelScreen;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ClientTextComponentUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaypointEditorScreen
extends AbstractButtonListScreen {
    private static final Logger log = LoggerFactory.getLogger(WaypointEditorScreen.class);
    private final Map<class_5321<class_1937>, Boolean> collapsed = new HashMap<class_5321<class_1937>, Boolean>();
    private final Map<class_5321<class_1937>, List<WaypointImpl>> waypoints = new HashMap<class_5321<class_1937>, List<WaypointImpl>>();
    private final Button buttonCollapseAll;
    private final Button buttonExpandAll;
    private int widestWaypoint = 0;

    public WaypointEditorScreen() {
        this.showBottomPanel(false);
        this.showCloseButton(true);
        this.buttonExpandAll = new SimpleButton(this.topPanel, List.of(class_2561.method_43471((String)"gui.expand_all"), TextComponentUtils.hotkeyTooltip((String)"="), TextComponentUtils.hotkeyTooltip((String)"+")), Icons.UP, (widget, button) -> this.toggleAll(true));
        this.buttonCollapseAll = new SimpleButton(this.topPanel, List.of(class_2561.method_43471((String)"gui.collapse_all"), TextComponentUtils.hotkeyTooltip((String)"-")), Icons.DOWN, (widget, button) -> this.toggleAll(false));
    }

    private void toggleAll(boolean collapsed) {
        boolean allOpen = this.collapsed.values().stream().noneMatch(b -> b);
        if (allOpen && !collapsed) {
            return;
        }
        this.collapsed.keySet().forEach(levelResourceKey -> this.collapsed.put((class_5321<class_1937>)levelResourceKey, collapsed));
        this.scrollBar.setValue(0.0);
        this.getGui().refreshWidgets();
    }

    protected void doCancel() {
    }

    protected void doAccept() {
    }

    public boolean onInit() {
        this.setWidth(class_3532.method_15340((int)(this.widestWaypoint + 80), (int)220, (int)(this.getScreen().method_4486() * 4 / 5)));
        this.setHeight(this.getScreen().method_4502() * 4 / 5);
        for (Map.Entry<class_5321<class_1937>, List<WaypointImpl>> resourceKeyListEntry : WaypointEditorScreen.collectWaypoints().entrySet()) {
            this.collapsed.put(resourceKeyListEntry.getKey(), false);
            this.waypoints.put(resourceKeyListEntry.getKey(), new ArrayList(resourceKeyListEntry.getValue()));
        }
        this.computeWaypointTextWidth();
        return true;
    }

    private void computeWaypointTextWidth() {
        this.widestWaypoint = 0;
        for (Map.Entry<class_5321<class_1937>, List<WaypointImpl>> dimKey : this.waypoints.entrySet()) {
            for (WaypointImpl wp : dimKey.getValue()) {
                this.widestWaypoint = Math.max(this.widestWaypoint, this.getTheme().getStringWidth(wp.getName()));
            }
        }
    }

    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if (key.is(334) || key.is(61)) {
            this.toggleAll(false);
        } else if (key.is(45) || key.is(333)) {
            this.toggleAll(true);
        }
        return false;
    }

    protected int getTopPanelHeight() {
        return 22;
    }

    protected Panel createTopPanel() {
        return new CustomTopPanel();
    }

    public void addButtons(Panel panel) {
        if (this.waypoints.isEmpty()) {
            panel.add((Widget)new NoWayPoints(panel, (class_2561)class_2561.method_43473(), Icons.REMOVE));
        }
        this.waypoints.forEach((key, value) -> {
            boolean startCollapsed = this.collapsed.get(key);
            GroupButton groupButton = new GroupButton(panel, (class_5321<class_1937>)key, startCollapsed, (List<WaypointImpl>)value);
            panel.add((Widget)groupButton);
            if (!startCollapsed) {
                panel.addAll(groupButton.collectPanels());
            }
        });
    }

    private static Map<class_5321<class_1937>, List<WaypointImpl>> collectWaypoints() {
        HashMap<class_5321<class_1937>, List<WaypointImpl>> res = new HashMap<class_5321<class_1937>, List<WaypointImpl>>();
        class_1657 player = (class_1657)Objects.requireNonNull(class_310.method_1551().field_1724);
        MapManager manager = MapManager.getInstance().orElseThrow();
        manager.getDimensions().values().stream().filter(dim -> !dim.getWaypointManager().isEmpty()).sorted((dim1, dim2) -> {
            class_2960 dim1id = dim1.dimension.method_29177();
            class_2960 dim2id = dim2.dimension.method_29177();
            if (dim1id.method_12836().equals("minecraft") && !dim2id.method_12836().equals("minecraft")) {
                return -1;
            }
            int i = dim1id.method_12836().compareTo(dim2id.method_12836());
            return i == 0 ? dim1id.method_12832().compareTo(dim2id.method_12832()) : i;
        }).forEach(dim -> res.put(dim.dimension, dim.getWaypointManager().stream().sorted(Comparator.comparingDouble(wp -> wp.getDistanceSq((class_1297)player))).toList()));
        return res;
    }

    protected class CustomTopPanel
    extends AbstractThreePanelScreen.TopPanel {
        private final TextField titleLabel;

        protected CustomTopPanel() {
            super((AbstractThreePanelScreen)WaypointEditorScreen.this);
            this.titleLabel = new TextField((Panel)this);
        }

        public void addWidgets() {
            this.titleLabel.setText((class_2561)class_2561.method_43471((String)"ftbchunks.gui.waypoints"));
            this.titleLabel.addFlags(32);
            this.add((Widget)this.titleLabel);
            if (WaypointEditorScreen.this.waypoints.size() > 1) {
                this.add((Widget)WaypointEditorScreen.this.buttonExpandAll);
                this.add((Widget)WaypointEditorScreen.this.buttonCollapseAll);
            }
        }

        public void alignWidgets() {
            this.titleLabel.setPosAndSize(4, 0, this.titleLabel.width, this.height);
            if (WaypointEditorScreen.this.waypoints.size() > 1) {
                WaypointEditorScreen.this.buttonExpandAll.setPos(this.width - 18, 2);
                WaypointEditorScreen.this.buttonCollapseAll.setPos(this.width - 38, 2);
            }
        }
    }

    protected static class NoWayPoints
    extends Button {
        private static final class_2561 NO_WAYPOINTS = class_2561.method_43471((String)"ftbchunks.gui.no_waypoints");

        public NoWayPoints(Panel panel, class_2561 t, Icon i) {
            super(panel);
        }

        public void onClicked(MouseButton button) {
        }

        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            super.drawBackground(graphics, theme, x, y, w, h);
            int stringWidth = theme.getStringWidth(NO_WAYPOINTS.getString());
            theme.drawString(graphics, (Object)NO_WAYPOINTS, x + (w - stringWidth) / 2, y + (h - theme.getFontHeight()) / 2 + 1);
        }
    }

    private class GroupButton
    extends Button {
        private final class_2561 titleText;
        private final List<RowPanel> rowPanels;
        private final class_5321<class_1937> dim;

        public GroupButton(Panel panel, class_5321<class_1937> dim, boolean startCollapsed, List<WaypointImpl> waypoints) {
            super(panel);
            this.dim = dim;
            this.titleText = TextComponentUtils.translatedDimension(dim).method_27661().method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)dim.method_29177().toString()))));
            this.setCollapsed(startCollapsed);
            this.rowPanels = new ArrayList<RowPanel>();
            for (WaypointImpl waypoint : waypoints) {
                this.rowPanels.add(new RowPanel(panel, waypoint));
            }
        }

        public List<RowPanel> collectPanels() {
            return this.isCollapsed() ? List.of() : List.copyOf(this.rowPanels);
        }

        public void onClicked(MouseButton button) {
            this.setCollapsed(!this.isCollapsed());
            this.parent.refreshWidgets();
            WaypointEditorScreen.this.refreshWidgets();
            this.playClickSound();
        }

        public boolean isCollapsed() {
            return WaypointEditorScreen.this.collapsed.get(this.dim);
        }

        public void setCollapsed(boolean collapsed) {
            WaypointEditorScreen.this.collapsed.put(this.dim, collapsed);
            boolean isCollapsed = this.isCollapsed();
            this.setTitle((class_2561)class_2561.method_43470((String)(isCollapsed ? "\u25b6 " : "\u25bc ")).method_27692(isCollapsed ? class_124.field_1061 : class_124.field_1060).method_10852(this.titleText));
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawWidget(graphics, x, y, w, h, this.getWidgetType());
            theme.drawString(graphics, (Object)this.getTitle(), x + 3, y + 3);
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
            }
        }

        public void addMouseOverText(TooltipList list) {
            list.add((class_2561)class_2561.method_43470((String)this.dim.method_29177().toString()));
        }
    }

    private class RowPanel
    extends Panel {
        private static final class_2561 DELETE = class_2561.method_43471((String)"ftbchunks.gui.delete");
        private static final class_2561 QUICK_DELETE = class_2561.method_43471((String)"ftbchunks.gui.quick_delete");
        private final WaypointImpl wp;
        private TextField nameField;
        private TextField distField;
        private SimpleButton hideButton;
        private SimpleButton deleteButton;

        public RowPanel(Panel panel, WaypointImpl wp) {
            super(panel);
            this.wp = wp;
            this.setHeight(18);
        }

        public void addWidgets() {
            this.hideButton = new ToggleableButton((Panel)this, !this.wp.isHidden(), (widget, newState) -> this.wp.setHidden(!newState));
            this.add((Widget)this.hideButton);
            this.nameField = new TextField((Panel)this).setTrim().setColor(Color4I.rgb((int)this.wp.getColor())).addFlags(2);
            this.add((Widget)this.nameField);
            class_746 player = class_310.method_1551().field_1724;
            String distStr = player.method_37908().method_27983().equals(this.wp.getDimension()) ? String.format("%.1fm", Math.sqrt(this.wp.getDistanceSq((class_1297)player))) : "";
            this.distField = new TextField((Panel)this).setText(distStr).setColor(Color4I.WHITE);
            this.add((Widget)this.distField);
            this.deleteButton = new SimpleButton(this, this, DELETE, Icons.BIN, (w, mb) -> this.deleteWaypoint(!RowPanel.isShiftKeyDown())){

                public class_2561 getTitle() {
                    return 1.isShiftKeyDown() ? QUICK_DELETE : DELETE;
                }

                public void drawIcon(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                    super.drawIcon(graphics, theme, x, y, 12, 12);
                }
            };
            this.add((Widget)this.deleteButton);
        }

        public void alignWidgets() {
        }

        public void setWidth(int newWidth) {
            super.setWidth(newWidth);
            if (newWidth > 0) {
                int farRight = newWidth - 8;
                int yOff = (this.height - WaypointEditorScreen.this.getTheme().getFontHeight()) / 2 + 1;
                this.hideButton.setPosAndSize(farRight - 8 - 16, 3, 12, 12);
                this.deleteButton.setPosAndSize(farRight - 8, 3, 12, 12);
                this.distField.setPos(this.hideButton.getPosX() - 5 - this.distField.width, yOff);
                this.nameField.setPos(5, yOff);
                this.nameField.setText(ClientTextComponentUtils.ellipsize((class_327)WaypointEditorScreen.this.getTheme().getFont(), (class_5348)this.wp.getDisplayName(), (int)(this.distField.getPosX() - 5)).getString());
                this.nameField.setHeight(WaypointEditorScreen.this.getTheme().getFontHeight() + 2);
            }
        }

        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            super.draw(graphics, theme, x, y, w, h);
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
            }
        }

        public boolean mouseDoubleClicked(MouseButton button) {
            if (this.isMouseOver()) {
                this.openWaypointEditPanel();
                return true;
            }
            return false;
        }

        private void openWaypointEditPanel() {
            StringConfig configName = new StringConfig();
            configName.setValue((Object)this.wp.getName());
            new FTBChunksClient.WaypointAddScreen(configName, class_4208.method_19443(this.wp.getDimension(), (class_2338)this.wp.getPos()), Color4I.rgb((int)this.wp.getColor()), true).openGui();
        }

        public boolean mousePressed(MouseButton button) {
            if (this.isMouseOver() && button.isRight()) {
                ArrayList<ContextMenuItem> list = new ArrayList<ContextMenuItem>();
                list.add(this.makeTitleMenuItem());
                list.add(ContextMenuItem.SEPARATOR);
                WaypointShareMenu.makeShareMenu((class_1657)class_310.method_1551().field_1724, this.wp).ifPresent(list::add);
                list.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.rename"), Icons.CHAT, btn -> {
                    StringConfig config = new StringConfig();
                    config.setDefaultValue((Object)"");
                    config.setValue((Object)this.wp.getName());
                    config.onClicked((Widget)btn, MouseButton.LEFT, accepted -> {
                        if (accepted) {
                            this.wp.setName((String)config.getValue());
                        }
                        WaypointEditorScreen.this.computeWaypointTextWidth();
                        this.openGui();
                    });
                }));
                if (this.wp.getType().canChangeColor()) {
                    list.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbchunks.gui.change_color"), Icons.COLOR_RGB, btn -> {
                        ColorConfig col = new ColorConfig();
                        col.setValue((Object)Color4I.rgb((int)this.wp.getColor()));
                        ColorSelectorPanel.popupAtMouse((BaseScreen)btn.getGui(), (ColorConfig)col, accepted -> {
                            if (accepted) {
                                this.wp.setColor(((Color4I)col.getValue()).rgba());
                                this.wp.refreshIcon();
                                Object patt0$temp = this.widgets.get(1);
                                if (patt0$temp instanceof TextField) {
                                    TextField tf = (TextField)patt0$temp;
                                    tf.setColor(Color4I.rgb((int)this.wp.getColor()));
                                }
                            }
                        });
                    }));
                }
                list.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbchunks.gui.edit"), Icons.SETTINGS, b -> this.openWaypointEditPanel()));
                if (class_310.method_1551().field_1724.method_5687(2)) {
                    list.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"ftbchunks.gui.teleport"), ItemIcon.getItemIcon((class_1792)class_1802.field_8634), btn -> {
                        NetworkManager.sendToServer((class_8710)new TeleportFromMapPacket(this.wp.getPos().method_10084(), false, this.wp.getDimension()));
                        this.closeGui(false);
                    }));
                }
                list.add(new ContextMenuItem((class_2561)class_2561.method_43471((String)"gui.remove"), Icons.REMOVE, btn -> this.deleteWaypoint(true)));
                this.getGui().openContextMenu(list);
                return true;
            }
            return super.mousePressed(button);
        }

        public boolean keyPressed(Key key) {
            if (key.is(261)) {
                this.deleteWaypoint(!RowPanel.isShiftKeyDown());
                return true;
            }
            return super.keyPressed(key);
        }

        private void deleteWaypoint(boolean gui) {
            if (gui) {
                this.getGui().openYesNo((class_2561)class_2561.method_43469((String)"ftbchunks.gui.delete_waypoint", (Object[])new Object[]{this.wp.getDisplayName().method_27661().method_27696(class_2583.field_24360.method_36139(this.wp.getColor()))}), (class_2561)class_2561.method_43473(), () -> {
                    this.wp.removeFromManager();
                    WaypointEditorScreen.this.waypoints.get(this.wp.getDimension()).remove(this.wp);
                    this.getGui().refreshWidgets();
                });
            } else {
                this.wp.removeFromManager();
                WaypointEditorScreen.this.waypoints.get(this.wp.getDimension()).remove(this.wp);
                this.getGui().refreshWidgets();
            }
        }

        private ContextMenuItem makeTitleMenuItem() {
            return new ContextMenuItem(this.wp.getDisplayName(), (Icon)Icon.empty(), null){

                public Icon getIcon() {
                    return RowPanel.this.wp.getType().getIcon().withTint(Color4I.rgb((int)RowPanel.this.wp.getColor()));
                }
            };
        }
    }
}

