/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.util;

import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class DimensionFilter {
    private static WildcardedRLMatcher dimensionMatcherB = null;
    private static WildcardedRLMatcher dimensionMatcherW = null;
    private static WildcardedRLMatcher noWilderness = null;

    public static boolean isDimensionOK(class_5321<class_1937> levelKey) {
        class_2960 name = levelKey.method_29177();
        return !DimensionFilter.getDimensionBlacklist().test(name) && (DimensionFilter.getDimensionWhitelist().isEmpty() || DimensionFilter.getDimensionWhitelist().test(name));
    }

    public static boolean isNoWildernessDimension(class_5321<class_1937> levelKey) {
        return DimensionFilter.getNoWildernessList().test(levelKey.method_29177());
    }

    private static WildcardedRLMatcher getDimensionWhitelist() {
        if (dimensionMatcherW == null) {
            dimensionMatcherW = new WildcardedRLMatcher((Collection)FTBChunksWorldConfig.CLAIM_DIMENSION_WHITELIST.get());
        }
        return dimensionMatcherW;
    }

    private static WildcardedRLMatcher getDimensionBlacklist() {
        if (dimensionMatcherB == null) {
            dimensionMatcherB = new WildcardedRLMatcher((Collection)FTBChunksWorldConfig.CLAIM_DIMENSION_BLACKLIST.get());
        }
        return dimensionMatcherB;
    }

    private static WildcardedRLMatcher getNoWildernessList() {
        if (noWilderness == null) {
            noWilderness = new WildcardedRLMatcher((Collection)FTBChunksWorldConfig.NO_WILDERNESS_DIMENSIONS.get());
        }
        return noWilderness;
    }

    public static void clearMatcherCaches() {
        dimensionMatcherB = null;
        dimensionMatcherW = null;
        noWilderness = null;
    }

    private static class WildcardedRLMatcher
    implements Predicate<class_2960> {
        private final Set<String> namespaces = new ObjectOpenHashSet();
        private final Set<class_2960> reslocs = new ObjectOpenHashSet();

        public WildcardedRLMatcher(Collection<String> toMatch) {
            for (String s : toMatch) {
                if (s.endsWith(":*")) {
                    this.namespaces.add(s.split(":")[0]);
                    continue;
                }
                class_2960 location = class_2960.method_12829((String)s);
                if (location == null) continue;
                this.reslocs.add(location);
            }
        }

        public boolean isEmpty() {
            return this.reslocs.isEmpty() && this.namespaces.isEmpty();
        }

        @Override
        public boolean test(class_2960 resourceLocation) {
            return this.reslocs.contains(resourceLocation) || this.namespaces.contains(resourceLocation.method_12836());
        }
    }
}

