/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesGroupControl;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.KeyType;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.util.FrameHelper;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModSecurity;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemKeyring;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import com.mojang.serialization.MapCodec;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class BlockController
extends class_2383
implements INetworked,
class_2343,
IFramedSourceBlock {
    public static final MapCodec<BlockController> CODEC = BlockController.method_54094(BlockController::new);

    public BlockController(class_4970.class_2251 properties) {
        super(properties);
    }

    public MapCodec<BlockController> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177});
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)context.method_8042().method_10153());
    }

    @NotNull
    public class_1269 method_55766(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_3965 hit) {
        if (!SecurityManager.canInteract(player, class_1268.field_5808, pos)) {
            return class_1269.field_5811;
        }
        class_2350 blockDir = (class_2350)state.method_11654((class_2769)field_11177);
        BlockEntityController blockEntity = com.texelsaurus.minecraft.chameleon.util.WorldUtils.getBlockEntity((class_1922)level, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return class_1269.field_5814;
        }
        class_1799 item = player.method_31548().method_7391();
        if (player.method_7357().method_7904(item.method_7909())) {
            return class_1269.field_5814;
        }
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        if (!item.method_7960() && this.toggle(level, pos, player, item.method_7909())) {
            return class_1269.field_5812;
        }
        if (blockDir != hit.method_17780()) {
            return class_1269.field_21466;
        }
        if (!level.field_9236) {
            class_1792 class_17922;
            if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue() && item.method_7960()) {
                blockEntity.printDebugInfo();
            }
            if ((class_17922 = item.method_7909()) instanceof ItemUpgradeRemote) {
                ItemUpgradeRemote remote = (ItemUpgradeRemote)class_17922;
                item = ItemUpgradeRemote.setBoundController(item, blockEntity);
                player.method_31548().method_5447(player.method_31548().field_7545, item);
                player.method_7353((class_2561)class_2561.method_43469((String)"message.storagedrawers.updated_remote_binding", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}), true);
            }
            blockEntity.interactPutItemsIntoInventory(player);
        }
        return class_1269.field_5812;
    }

    public boolean toggle(class_1937 world, class_2338 pos, class_1657 player, class_1792 item) {
        ItemKey itemKey;
        if (world.field_9236 || item == null) {
            return false;
        }
        class_1792 keyItem = item;
        if (item instanceof ItemKeyring) {
            ItemKeyring keyring = (ItemKeyring)item;
            keyItem = keyring.getKey().method_7909();
        }
        if (keyItem instanceof ItemKey && !(itemKey = (ItemKey)keyItem).isEnabled()) {
            return false;
        }
        if (keyItem == ModItems.DRAWER_KEY.get()) {
            this.toggle(world, pos, player, KeyType.DRAWER);
        } else if (keyItem == ModItems.SHROUD_KEY.get()) {
            this.toggle(world, pos, player, KeyType.CONCEALMENT);
        } else if (keyItem == ModItems.QUANTIFY_KEY.get()) {
            this.toggle(world, pos, player, KeyType.QUANTIFY);
        } else if (keyItem == ModItems.SUSPEND_KEY.get()) {
            this.toggle(world, pos, player, KeyType.SUSPEND);
        } else if (keyItem instanceof ItemPersonalKey) {
            itemKey = (ItemPersonalKey)keyItem;
            this.togglePersonal(world, pos, player, ((ItemPersonalKey)itemKey).getSecurityProviderKey());
        } else {
            return false;
        }
        player.method_7357().method_7906(item, 5);
        return true;
    }

    public void toggle(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull KeyType keyType) {
        if (level.field_9236) {
            return;
        }
        if (!keyType.isEnabled()) {
            return;
        }
        BlockEntityController blockEntity = com.texelsaurus.minecraft.chameleon.util.WorldUtils.getBlockEntity((class_1922)level, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return;
        }
        IDrawerAttributesGroupControl controlAttrs = blockEntity.getGroupControllableAttributes(player);
        if (controlAttrs != null) {
            if (keyType == KeyType.DRAWER) {
                controlAttrs.toggleItemLocked(EnumSet.allOf(LockAttribute.class), LockAttribute.LOCK_POPULATED);
            } else if (keyType == KeyType.CONCEALMENT) {
                controlAttrs.toggleConcealed();
            } else if (keyType == KeyType.QUANTIFY) {
                controlAttrs.toggleIsShowingQuantity();
            } else if (keyType == KeyType.SUSPEND) {
                controlAttrs.toggleIsSuspended();
            }
        }
    }

    public void togglePersonal(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, String providerKey) {
        if (level.field_9236) {
            return;
        }
        if (!((Boolean)ModCommonConfig.INSTANCE.TOOLS.personalKey.enable.get()).booleanValue()) {
            return;
        }
        BlockEntityController blockEntity = WorldUtils.getBlockEntity((class_1922)level, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return;
        }
        if (Objects.equals(providerKey, "unlock")) {
            blockEntity.clearProtection();
            return;
        }
        ISecurityProvider provider = ModSecurity.registry.getProvider(providerKey);
        blockEntity.toggleProtection(player.method_7334(), provider);
    }

    public void method_9588(@NotNull class_2680 state, @NotNull class_3218 world, @NotNull class_2338 pos, @NotNull class_5819 rand) {
        if (world.field_9236) {
            return;
        }
        BlockEntityController blockEntity = com.texelsaurus.minecraft.chameleon.util.WorldUtils.getBlockEntity((class_1922)world, pos, BlockEntityController.class);
        if (blockEntity == null) {
            return;
        }
        blockEntity.updateCache();
        world.method_39279(pos, (class_2248)this, 100);
    }

    public BlockEntityController newBlockEntity(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return (BlockEntityController)ModServices.RESOURCE_FACTORY.createBlockEntityController().create(pos, state);
    }

    @Override
    public class_1799 makeFramedItem(class_1799 source, class_1799 matSide, class_1799 matTrim, class_1799 matFront) {
        return FrameHelper.makeFramedItem((IFramedBlock)ModBlocks.FRAMED_CONTROLLER.get(), source, matSide, matTrim, matFront);
    }
}

