/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.config.StorageBlacklist;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackTagMatcher;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public abstract class StandardDrawerGroup
extends BlockEntityDataShim
implements IDrawerGroup {
    private final DrawerData[] slots;
    private final int[] order;

    public StandardDrawerGroup(int slotCount) {
        this.slots = new DrawerData[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            this.slots[i] = this.createDrawer(i);
        }
        this.order = new int[slotCount];
        this.syncSlots();
    }

    @Override
    public int getDrawerCount() {
        return this.slots.length;
    }

    @Override
    @NotNull
    public IDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.slots.length) {
            return Drawers.DISABLED;
        }
        return this.slots[slot];
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        return this.order;
    }

    @Override
    public void read(class_7225.class_7874 provider, class_2487 tag) {
        if (!tag.method_10545("Drawers")) {
            return;
        }
        class_2499 itemList = tag.method_10554("Drawers", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            if (i >= this.slots.length) continue;
            this.slots[i].deserializeNBT(provider, itemList.method_10602(i));
        }
    }

    @Override
    public class_2487 write(class_7225.class_7874 provider, class_2487 tag) {
        if (this.slots == null) {
            return tag;
        }
        class_2499 itemList = new class_2499();
        for (DrawerData slot : this.slots) {
            itemList.add((Object)slot.serializeNBT(provider));
        }
        tag.method_10566("Drawers", (class_2520)itemList);
        return tag;
    }

    @NotNull
    protected abstract DrawerData createDrawer(int var1);

    public void syncAttributes() {
        for (DrawerData drawer : this.slots) {
            drawer.syncAttributes();
        }
    }

    public void syncSlots() {
        IDrawer drawer;
        int i;
        int index = 0;
        for (i = 0; i < this.slots.length; ++i) {
            drawer = this.getDrawer(i);
            if (drawer.isEmpty()) continue;
            this.order[index++] = i;
        }
        if (index != this.slots.length) {
            for (i = 0; i < this.slots.length; ++i) {
                drawer = this.getDrawer(i);
                if (!drawer.isEnabled() || !drawer.isEmpty()) continue;
                this.order[index++] = i;
            }
        }
        if (index != this.slots.length) {
            for (i = 0; i < this.slots.length; ++i) {
                drawer = this.getDrawer(i);
                if (drawer.isEnabled()) continue;
                this.order[index++] = i;
            }
        }
    }

    public static class DrawerData
    implements IDrawer {
        protected IDrawerAttributes cachedAttrs;
        protected StandardDrawerGroup group;
        @NotNull
        private class_1799 protoStack;
        private int count;
        private ItemStackMatcher matcher;
        private boolean missing;

        public DrawerData(StandardDrawerGroup group) {
            this.group = group;
            this.protoStack = class_1799.field_8037;
            this.matcher = ItemStackMatcher.EMPTY;
            this.missing = false;
        }

        protected DrawerData(DrawerData data) {
            this(data.group);
            this.cachedAttrs = data.cachedAttrs;
            this.protoStack = data.protoStack;
            this.count = data.count;
            this.matcher = data.matcher;
        }

        @Override
        @NotNull
        public IDrawerAttributes getAttributes() {
            if (this.cachedAttrs != null) {
                return this.cachedAttrs;
            }
            this.cachedAttrs = this.group.getCapability(Capabilities.DRAWER_ATTRIBUTES);
            if (this.cachedAttrs != null) {
                return this.cachedAttrs;
            }
            return EmptyDrawerAttributes.EMPTY;
        }

        @Override
        @NotNull
        public class_1799 getStoredItemPrototype() {
            if (this.isMissing()) {
                return class_1799.field_8037;
            }
            return this.protoStack;
        }

        @Override
        @NotNull
        public IDrawer setStoredItem(@NotNull class_1799 itemPrototype) {
            return this.setStoredItem(itemPrototype, true);
        }

        protected IDrawer setStoredItem(@NotNull class_1799 itemPrototype, boolean notify) {
            if (this.isMissing()) {
                return this;
            }
            if (ItemStackHelper.isStackEncoded(itemPrototype)) {
                itemPrototype = ItemStackHelper.decodeItemStackPrototype(itemPrototype);
            }
            if (this.matcher.matches(itemPrototype)) {
                return this;
            }
            if ((itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype)).method_7960()) {
                this.reset(notify);
                return this;
            }
            this.protoStack = itemPrototype;
            this.protoStack.method_7939(1);
            this.count = 0;
            IDrawerAttributes attrs = this.getAttributes();
            this.matcher = attrs.isDictConvertible() ? new ItemStackTagMatcher(this.protoStack) : new ItemStackMatcher(this.protoStack);
            this.group.syncSlots();
            if (notify) {
                this.onItemChanged();
            }
            return this;
        }

        protected IDrawer setStoredItemRaw(@NotNull class_1799 itemPrototype) {
            this.protoStack = itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype);
            this.protoStack.method_7939(1);
            this.count = 0;
            IDrawerAttributes attrs = this.getAttributes();
            this.matcher = attrs.isDictConvertible() ? new ItemStackTagMatcher(this.protoStack) : new ItemStackMatcher(this.protoStack);
            return this;
        }

        @Override
        public int getStoredItemCount() {
            if (this.isMissing() || this.protoStack.method_7960()) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.count;
        }

        @Override
        public void setStoredItemCount(int amount) {
            this.setStoredItemCount(amount, true);
        }

        protected void setStoredItemCount(int amount, boolean notify) {
            if (this.isMissing() || this.protoStack.method_7960() || this.count == amount) {
                return;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return;
            }
            this.count = Math.min(amount, this.getMaxCapacity());
            this.count = Math.max(this.count, 0);
            if (this.count == 0 && !attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                this.reset(notify);
            } else if (notify) {
                this.onAmountChanged();
            }
        }

        protected void setStoredItemCountRaw(int amount) {
            this.count = amount;
        }

        @Override
        public int adjustStoredItemCount(int amount) {
            return this.adjustStoredItemCount(amount, true);
        }

        protected int adjustStoredItemCount(int amount, boolean notify) {
            if (this.isMissing() || this.protoStack.method_7960() || amount == 0) {
                return Math.abs(amount);
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (amount > 0) {
                if (attrs.isUnlimitedVending()) {
                    return 0;
                }
                int originalCount = this.count;
                this.count = (long)this.count + (long)amount > Integer.MAX_VALUE ? this.getMaxCapacity() : Math.min(this.count + amount, this.getMaxCapacity());
                if (this.count != originalCount && notify) {
                    this.onAmountChanged();
                }
                if (attrs.isVoid()) {
                    return 0;
                }
                return amount - (this.count - originalCount);
            }
            if (attrs.isUnlimitedVending()) {
                return 0;
            }
            int originalCount = this.count;
            this.setStoredItemCount(originalCount + amount, notify);
            return -amount - (originalCount - this.count);
        }

        @Override
        public int getMaxCapacity(@NotNull class_1799 itemPrototype) {
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedStorage() || attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            if (itemPrototype.method_7960()) {
                return 64 * this.getStackCapacity();
            }
            try {
                return Math.multiplyExact(DrawerData.getStackSize(itemPrototype), this.getStackCapacity());
            }
            catch (ArithmeticException e) {
                return Integer.MAX_VALUE;
            }
        }

        public static int getStackSize(@NotNull class_1799 itemPrototype) {
            if (itemPrototype.method_7960()) {
                return 64;
            }
            return itemPrototype.method_7909().method_7882();
        }

        @Override
        public int getAcceptingMaxCapacity(@NotNull class_1799 itemPrototype) {
            if (this.isMissing()) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity(itemPrototype);
        }

        @Override
        public int getRemainingCapacity() {
            if (this.isMissing() || this.protoStack.method_7960()) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity() - this.getStoredItemCount();
        }

        @Override
        public int getAcceptingRemainingCapacity() {
            if (this.isMissing() || this.protoStack.method_7960()) {
                return 0;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (attrs.isUnlimitedVending() || attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            return this.getMaxCapacity() - this.getStoredItemCount();
        }

        @Override
        public boolean canItemBeStored(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
            return this.canItemBeStored(itemPrototype, matchPredicate, false);
        }

        @Override
        public boolean canItemBeStoredManual(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
            return this.canItemBeStored(itemPrototype, matchPredicate, true);
        }

        private boolean canItemBeStored(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate, boolean manualStore) {
            if (this.isMissing()) {
                return false;
            }
            if (StorageBlacklist.INSTANCE.isBlacklisted(itemPrototype)) {
                return false;
            }
            IDrawerAttributes attrs = this.getAttributes();
            if (this.protoStack.method_7960() && (manualStore || !attrs.isItemLocked(LockAttribute.LOCK_EMPTY))) {
                return true;
            }
            if (matchPredicate == null) {
                return this.matcher.matches(itemPrototype);
            }
            return matchPredicate.test(this.protoStack);
        }

        @Override
        public boolean canItemBeExtracted(@NotNull class_1799 itemPrototype, Predicate<class_1799> matchPredicate) {
            if (this.isMissing() || this.protoStack.method_7960()) {
                return false;
            }
            if (matchPredicate == null) {
                return this.matcher.matches(itemPrototype);
            }
            return matchPredicate.test(this.protoStack);
        }

        @Override
        public boolean isEmpty() {
            return this.isMissing() || this.protoStack.method_7960();
        }

        protected void reset(boolean notify) {
            this.protoStack = class_1799.field_8037;
            this.count = 0;
            this.matcher = ItemStackMatcher.EMPTY;
            this.group.syncSlots();
            if (notify) {
                this.onItemChanged();
            }
        }

        public class_2487 serializeNBT(class_7225.class_7874 provider) {
            class_2487 tag = new class_2487();
            tag.method_10556("Missing", this.missing);
            if (this.protoStack.method_7960()) {
                return tag;
            }
            class_2487 item = new class_2487();
            item = (class_2487)this.protoStack.method_57376(provider, (class_2520)item);
            tag.method_10566("Item", (class_2520)item);
            tag.method_10569("Count", this.count);
            return tag;
        }

        public void deserializeNBT(class_7225.class_7874 provider, class_2487 nbt) {
            class_1799 tagItem = class_1799.field_8037;
            int tagCount = 0;
            boolean tagMissing = false;
            if (nbt.method_10545("Item")) {
                tagItem = class_1799.method_57359((class_7225.class_7874)provider, (class_2487)nbt.method_10562("Item"));
            }
            if (nbt.method_10545("Count")) {
                tagCount = nbt.method_10550("Count");
            }
            if (nbt.method_10545("Missing")) {
                tagMissing = nbt.method_10577("Missing");
            }
            this.setStoredItemRaw(tagItem);
            this.setStoredItemCountRaw(tagCount);
            this.missing = tagMissing;
        }

        public void syncAttributes() {
            if (!this.protoStack.method_7960()) {
                this.matcher = new ItemStackMatcher(this.protoStack);
            }
        }

        protected int getStackCapacity() {
            return 0;
        }

        protected void onItemChanged() {
        }

        protected void onAmountChanged() {
        }

        @Override
        public boolean canDetach() {
            return true;
        }

        @Override
        public boolean isMissing() {
            return this.missing;
        }

        @Override
        public void setDetached(boolean state) {
            if (this.missing != state) {
                if (state) {
                    this.setStoredItem(class_1799.field_8037);
                }
                this.missing = state;
            }
        }

        @Override
        public IDrawer copy() {
            return new DrawerData(this);
        }
    }
}

