/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_296;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_777;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpriteReplacementModel
extends ParentModel {
    private class_1058 sprite;
    private Map<String, List<class_777>> cache = new HashMap<String, List<class_777>>();

    public SpriteReplacementModel(@NotNull class_1087 parent, class_1058 sprite) {
        super(parent);
        this.sprite = sprite;
    }

    public SpriteReplacementModel(@NotNull class_1087 parent, class_1087 replacement) {
        super(parent);
        this.sprite = replacement.method_4711();
    }

    public SpriteReplacementModel(@NotNull class_1087 parent, class_1799 stack) {
        super(parent);
        class_1792 class_17922;
        if (stack != null && (class_17922 = stack.method_7909()) instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_2248 block = blockItem.method_7711();
            class_776 disp = class_310.method_1551().method_1541();
            class_1087 model = disp.method_3349(block.method_9564());
            this.sprite = model.method_4711();
        }
    }

    @Override
    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 dir, class_5819 rand) {
        if (this.sprite == null) {
            return super.method_4707(state, dir, rand);
        }
        String key = this.cacheKey(state, dir);
        List<class_777> list = this.cache.getOrDefault(key, null);
        if (list == null) {
            list = super.method_4707(state, dir, rand).stream().map(bakedQuad -> new ReplacementBakedQuad((class_777)bakedQuad, this.sprite)).toList();
            this.cache.put(key, list);
        }
        return list;
    }

    @Override
    public class_1058 method_4711() {
        if (this.sprite == null) {
            return super.method_4711();
        }
        return this.sprite;
    }

    private String cacheKey(@Nullable class_2680 state, @Nullable class_2350 dir) {
        return (state != null ? state.toString() : "") + "#" + (dir != null ? dir.toString() : "");
    }

    private static class ReplacementBakedQuad
    extends class_777 {
        class_1058 sprite;

        public ReplacementBakedQuad(class_777 quad, @NotNull class_1058 sprite) {
            super((int[])quad.method_3357().clone(), quad.method_3359(), quad.method_3358(), quad.method_35788(), quad.method_24874());
            this.sprite = sprite;
            this.remapQuad();
        }

        @NotNull
        public class_1058 method_35788() {
            return this.sprite;
        }

        private void remapQuad() {
            for (int i = 0; i < 4; ++i) {
                int blk = class_290.field_1590.method_1362() / 4 * i;
                int offset = class_290.field_1590.method_60835(class_296.field_52110) / 4;
                this.field_4175[blk + offset] = Float.floatToRawIntBits(this.sprite.method_4580(this.getUnInterpolatedU(this.field_4176, Float.intBitsToFloat(this.field_4175[blk + offset]))));
                this.field_4175[blk + offset + 1] = Float.floatToRawIntBits(this.sprite.method_4570(this.getUnInterpolatedV(this.field_4176, Float.intBitsToFloat(this.field_4175[blk + offset + 1]))));
            }
        }

        private float getUnInterpolatedU(class_1058 sprite, float u) {
            float diff = sprite.method_4577() - sprite.method_4594();
            return (u - sprite.method_4594()) / diff;
        }

        private float getUnInterpolatedV(class_1058 sprite, float v) {
            float diff = sprite.method_4575() - sprite.method_4593();
            return (v - sprite.method_4593()) / diff;
        }
    }
}

