/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model.decorator;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.client.model.DrawerModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.context.DrawerModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4722;

public class DrawerModelDecorator
extends ModelDecorator<DrawerModelContext> {
    protected final DrawerModelStore.DecorationSet overlays;

    public DrawerModelDecorator(DrawerModelStore.DecorationSet overlays) {
        this.overlays = overlays;
    }

    @Override
    public List<class_1921> getRenderTypes(class_2680 state) {
        return List.of(class_1921.method_23579());
    }

    @Override
    public List<class_1921> getRenderTypes(class_1799 stack) {
        return List.of(class_4722.method_24074());
    }

    @Override
    public void emitQuads(Supplier<DrawerModelContext> contextSupplier, BiConsumer<class_1087, class_1921> emitModel) {
        DrawerModelContext context = contextSupplier.get();
        if (context == null) {
            return;
        }
        this.emitDecoratedQuads(context, emitModel);
    }

    public void emitDecoratedQuads(DrawerModelContext context, BiConsumer<class_1087, class_1921> emitModel) {
        IDrawerGroup group;
        boolean isClaimed;
        class_2350 dir = (class_2350)context.state().method_11654((class_2769)BlockDrawers.field_11177);
        boolean drawerHalf = false;
        class_2248 block = context.state().method_26204();
        if (block instanceof BlockDrawers) {
            BlockDrawers drawers = (BlockDrawers)block;
            drawerHalf = drawers.isHalfDepth();
        }
        boolean half = drawerHalf;
        IDrawerAttributes attr = context.attr();
        if (attr == null) {
            return;
        }
        IProtectable protectable = context.protectable();
        boolean isLocked = attr.isItemLocked(LockAttribute.LOCK_EMPTY) || attr.isItemLocked(LockAttribute.LOCK_POPULATED);
        boolean bl = isClaimed = protectable != null && protectable.getOwner() != null;
        if (isLocked && isClaimed) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.LOCK_CLAIM, dir, half), class_1921.method_23579());
        } else if (isLocked) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.LOCK, dir, half), class_1921.method_23579());
        } else if (isClaimed) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.CLAIM, dir, half), class_1921.method_23579());
        }
        BiConsumer<DrawerModelStore.DynamicPart, Integer> emitIcon = (part, index) -> emitModel.accept(DrawerModelStore.getReplacementModel(DrawerModelStore.DynamicPart.RIGHT_LABEL, dir, half, index, part), class_1921.method_23579());
        int iconIndex = 1;
        int priority = attr.getPriority();
        if (attr.isVoid()) {
            emitIcon.accept(DrawerModelStore.DynamicPart.VOID_ICON, iconIndex++);
        }
        if (priority == -2) {
            emitIcon.accept(DrawerModelStore.DynamicPart.PRIORITY_N2_ICON, iconIndex++);
        }
        if (priority == -1) {
            emitIcon.accept(DrawerModelStore.DynamicPart.PRIORITY_N1_ICON, iconIndex++);
        }
        if (priority == 1) {
            emitIcon.accept(DrawerModelStore.DynamicPart.PRIORITY_P1_ICON, iconIndex++);
        }
        if (priority == 2) {
            emitIcon.accept(DrawerModelStore.DynamicPart.PRIORITY_P2_ICON, iconIndex++);
        }
        if (attr.isMagnet()) {
            emitIcon.accept(DrawerModelStore.DynamicPart.MAGNET_ICON, iconIndex++);
        }
        if (attr.isConcealed()) {
            emitIcon.accept(DrawerModelStore.DynamicPart.SHROUD_ICON, iconIndex++);
        }
        if (attr.isSuspended()) {
            emitIcon.accept(DrawerModelStore.DynamicPart.SUSPEND_ICON, iconIndex++);
        }
        if (attr.hasFillLevel()) {
            if (block instanceof BlockCompDrawers) {
                BlockCompDrawers compBlock = (BlockCompDrawers)block;
                count = compBlock.getDrawerCount();
                emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.INDICATOR_COMP, dir, half, count), class_1921.method_23579());
            } else if (block instanceof BlockStandardDrawers) {
                BlockStandardDrawers stdBlock = (BlockStandardDrawers)block;
                count = stdBlock.getDrawerCount();
                emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.INDICATOR, dir, half, count), class_1921.method_23579());
            }
        }
        if (attr.isHopper()) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.HOPPER), class_1921.method_23579());
        }
        if (block instanceof BlockStandardDrawers && (group = context.group()) != null) {
            int count = group.getDrawerCount();
            DrawerModelStore.DynamicPart[] groupMissingSlots = DrawerModelStore.missingSlots[count - 1];
            for (int i = 0; i < groupMissingSlots.length; ++i) {
                if (!group.getDrawer(i).isMissing()) continue;
                emitModel.accept(DrawerModelStore.getModel(groupMissingSlots[i], dir, half, count), class_1921.method_23579());
            }
        }
    }
}

