/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ConversionRegistry {
    public static final ConversionRegistry INSTANCE = new ConversionRegistry();
    private Set<class_6862<class_1792>> tagWhitelist = new HashSet<class_6862<class_1792>>();
    private Set<class_6862<class_1792>> tagBlacklist = new HashSet<class_6862<class_1792>>();
    private List<Set<class_2960>> equivGroups = new ArrayList<Set<class_2960>>();

    public void initialize() {
        ModCommonConfig.INSTANCE.onLoad(() -> {
            ((List)ModCommonConfig.INSTANCE.UPGRADES.conversionUpgrade.tagWhitelist.get()).forEach(this::addWhitelist);
            ((List)ModCommonConfig.INSTANCE.UPGRADES.conversionUpgrade.tagBlacklist.get()).forEach(this::addBlacklist);
            List oreTypes = (List)ModCommonConfig.INSTANCE.UPGRADES.conversionUpgrade.oreTypes.get();
            List oreMats = (List)ModCommonConfig.INSTANCE.UPGRADES.conversionUpgrade.oreMaterials.get();
            if (!oreTypes.isEmpty() && !oreMats.isEmpty() && ((Boolean)ModCommonConfig.INSTANCE.GENERAL.logStartupActivity.get()).booleanValue()) {
                ModServices.log.info("Adding ore conversions for types: " + oreTypes.stream().collect(Collectors.joining(", ")));
                ModServices.log.info("Adding ore conversions for materials: " + oreMats.stream().collect(Collectors.joining(", ")));
            }
            for (String oreType : oreTypes) {
                for (String oreMat : oreMats) {
                    this.addWhitelist(oreType + "/" + oreMat, false);
                }
            }
            for (String entry : (List)ModCommonConfig.INSTANCE.UPGRADES.conversionUpgrade.itemEquivGroups.get()) {
                this.addEquivGroup(entry);
            }
        });
    }

    public boolean addBlacklist(String entry) {
        String[] parts = entry.split(":");
        if (parts.length != 2) {
            return false;
        }
        return this.addBlacklist(parts[0], parts[1]);
    }

    public boolean addBlacklist(String namespace, String path) {
        return this.addBlacklist(class_2960.method_60655((String)namespace, (String)path));
    }

    public boolean addBlacklist(class_2960 entry) {
        if (entry == null) {
            return false;
        }
        this.tagBlacklist.add((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)entry));
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.logStartupActivity.get()).booleanValue()) {
            ModServices.log.info("New conversion denied tag " + String.valueOf(entry));
        }
        return true;
    }

    public boolean addWhitelist(String entry) {
        return this.addWhitelist(entry, true);
    }

    public boolean addWhitelist(String entry, boolean log) {
        String[] parts = entry.split(":");
        if (parts.length != 2) {
            return false;
        }
        return this.addWhitelist(parts[0], parts[1], log);
    }

    public boolean addWhitelist(String namespace, String path, boolean log) {
        return this.addWhitelist(class_2960.method_60655((String)namespace, (String)path), log);
    }

    public boolean addWhitelist(class_2960 entry, boolean log) {
        if (entry == null) {
            return false;
        }
        this.tagWhitelist.add((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)entry));
        if (log && ((Boolean)ModCommonConfig.INSTANCE.GENERAL.logStartupActivity.get()).booleanValue()) {
            ModServices.log.info("New conversion allowed tag " + String.valueOf(entry));
        }
        return true;
    }

    public void addEquivGroup(String entry) {
        String[] items = entry.split(";\\s*");
        HashSet<class_2960> group = new HashSet<class_2960>();
        for (String item : items) {
            String[] parts = item.split(":");
            if (parts.length != 2) continue;
            class_2960 key = class_2960.method_60655((String)parts[0], (String)parts[1]);
            group.add(key);
        }
        if (group.size() > 1) {
            this.equivGroups.add(group);
            if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.logStartupActivity.get()).booleanValue()) {
                ModServices.log.info("New conversion equivalence rule " + entry);
            }
        }
    }

    public boolean itemsShareEquivGroup(class_1792 item1, class_1792 item2) {
        class_2960 key1 = class_7923.field_41178.method_10221((Object)item1);
        class_2960 key2 = class_7923.field_41178.method_10221((Object)item2);
        for (Set<class_2960> group : this.equivGroups) {
            if (!group.contains(key1) || !group.contains(key2)) continue;
            return true;
        }
        return false;
    }

    public List<class_1799> getEquivItems(class_1792 item) {
        class_2960 key = class_7923.field_41178.method_10221((Object)item);
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (Set<class_2960> group : this.equivGroups) {
            if (!group.contains(key)) continue;
            for (class_2960 entry : group) {
                class_1792 other = (class_1792)class_7923.field_41178.method_10223(entry);
                items.add(new class_1799((class_1935)other));
            }
        }
        return items;
    }

    public boolean isEntryValid(class_6862<class_1792> entry) {
        if (this.tagBlacklist.contains(entry)) {
            return false;
        }
        return this.tagWhitelist.contains(entry);
    }
}

