```json
{
  "title": "Jukebox",
  "icon": "minecraft:jukebox",
  "categories": [
    "minecraft:blocks",
    "minecraft:group.functional_blocks",
    "minecraft:group.redstone_blocks"
  ],
  "associated_items": [
    "minecraft:jukebox"
  ]
}
```

&spotlight(minecraft:jukebox)
A **jukebox** is a block used to play [music discs](^minecraft:tag.music_discs).

;;;;;

&title(Crafting)
<recipe;minecraft:jukebox>

;;;;;

&title(Usage)
Using (<keybind;key.use>) a [music disc](^minecraft:tag.music_discs) on a jukebox inserts the disc and plays music corresponding to the type of music disc used. Pressing <keybind;key.use> on the jukebox again ejects the disc and stops any music playing. Music discs play only once before they must be ejected and reinserted.

;;;;;

Note particles emit out the top when sound is playing.


Unlike most other blocks, the sound from the jukebox can be heard from up to 64 blocks away.


[Hoppers](^minecraft:hopper) and [droppers](^minecraft:dropper) can be used to insert a disc into a jukebox.


Tamed [parrots](^minecraft:parrot) and [allays](^minecraft:allay) dance when in a 3 block radius from a jukebox that is playing a disc. 

;;;;;

&title(Allay Duplication)
If an [amethyst shard](^minecraft:amethyst_shard) is used on an [allay](^minecraft:allay) dancing next to a playing jukebox, the allay consumes the amethyst shard, emits heart particles, and duplicates into two allays. Both allays have a 5-minute cooldown before they can be duplicated again.

;;;;;

&title(Redstone Component)
A jukebox can act as a redstone power source. A redstone signal of strength 15 is emitted while music from a disc is playing, powering any adjacent [redstone wires](^minecraft:redstone_dust), [redstone repeaters](^minecraft:redstone_repeater), and mechanism components. The signal turns off when the music track ends or if the disc is removed before the track ends.

;;;;;

&title(Redstone Component)
A jukebox also emits a redstone signal when a [redstone comparator](^minecraft:redstone_comparator) is placed directly behind it or through an adjoining block. The signal strength depends on the ID of the inserted disc; the following table shows the redstone strength output for each disc. The comparator is powered as long as the music disc is stored in the jukebox, even if it has stopped playing.