```json
{
  "title": "Warden",
  "icon_sprite": "minecraft:icon/warden",
  "categories": [
    "minecraft:mobs",
    "minecraft:hostile_mobs",
    "minecraft:group.spawn_eggs"
  ],
  "associated_items": [
    "minecraft:warden_spawn_egg"
  ]
}
```

A **warden** is a powerful but avoidable [hostile mob](^minecraft:hostile_mobs) summoned by [sculk shriekers](^minecraft:sculk_shrieker) in the [deep dark biome](^minecraft:deep_dark). It attacks by swinging its arms downward or by using its sonic boom. The arm attack does more melee damage than any attack from any other mob, and the sonic boom cannot be blocked by obstacles or [armor](^minecraft:armor), making the warden one of the strongest mobs.

;;;;;

&title(Appearance)
<entity;minecraft:warden>

;;;;;

&title(Blindness)
Wardens are completely blind, so they have to rely on vibrations, smell, and touch in order to detect players and [mobs](^minecraft:mobs). Therefore, a warden can be evaded by sneaking, by diverting its attention to other sounds (for example, the sound of a snowball or arrow hitting a wall), or by hiding behind wool. 

;;;;;

&title(Spawning)
Wardens do not follow the standard mob spawning rules. Instead, a warden is spawned when a player in Survival, Adventure or Creative mode activates any number of naturally generated [sculk shriekers](^minecraft:sculk_shrieker) four times.

;;;;;

&title(Warning Level)
Each player has a warning level, which increases every time that player activates a naturally generated [sculk shrieker](^minecraft:sculk_shrieker). A sculk shrieker that has already been activated by a player before activates the same way it does normally, and the warning level does not reset if the player were to activate a new sculk shrieker.

;;;;;

&title(Warning Level)
The distance between the [shriekers](^minecraft:sculk_shrieker) doesn't matter. The shrieker spawns a warden 4.5 seconds after the warning level reaches 4, or immediately if the sculk shrieker is destroyed. If the warning level is already at 4, it stays at 4 and spawns another warden.

;;;;;

&title(Size)
A warden can fit inside any space that is 1 block wide and 3 blocks tall, allowing it to chase players and [mobs](^minecraft:mobs) through small corridors.

;;;;;

&title(Behavior)
After spawning, wardens wander randomly and move toward nearby vibrations originating from players, [mobs](^minecraft:mobs), and non-mob sources including projectiles and minecarts. 

;;;;;

&title(Sniffing)
A warden also periodically sniffs the area around it, allowing it to zero in on targets even if they don't create vibrations. As wardens sniff, pick up vibrations, or are touched by other players or mobs, they become increasingly agitated. 

;;;;;

![Warden Inspecting a Zombie](minecraft:textures/gui/image/warden_inspecting_a_zombie.png,fit)

A warden inspecting a zombie.

;;;;;

&title(Immunity)
Wardens are immune to damage from fire or lava, and are immune to knockback. They pursue through blocks that are usually avoided by other [mobs](^minecraft:mobs), including rails, cacti, or magma blocks.